/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.BlankAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class FieldSelectionDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ModelAnnotationMeta.class;
    private Label wlAvailable;
    private Label wlSelected;
    private org.eclipse.swt.widgets.List wAvailable;
    private ListViewer wSelected;
    private Button wAdd;
    private Button wAddAll;
    private Button wRemove;
    private Button wRemoveAll;
    private RowMetaInterface prevStepFields;
    private final ModelAnnotationGroup modelAnnotations;
    private Label wBottomHorizontalSeparator;
    private Listener lsClose;

    public FieldSelectionDialog(Shell parent, StepMetaInterface baseStepMeta, TransMeta transMeta, String stepname, ModelAnnotationGroup modelAnnotations) {
        super(parent, baseStepMeta, transMeta, stepname);
        this.modelAnnotations = modelAnnotations;
        try {
            this.prevStepFields = transMeta.getPrevStepFields(stepname);
        }
        catch (KettleStepException e) {
            e.printStackTrace();
        }
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 268503152);
        this.shell.setSize(600, 500);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.Title", (String[])new String[0]));
        this.initializeWidgets();
        this.initializeListeners();
        this.layoutWidgets();
        this.populateLists();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void initializeListeners() {
        this.wAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FieldSelectionDialog.this.addField();
            }
        });
        this.wAddAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (String field : FieldSelectionDialog.this.wAvailable.getItems()) {
                    BlankAnnotation annotation = new BlankAnnotation();
                    annotation.setField(field);
                    ModelAnnotation modelAnnotation = new ModelAnnotation((AnnotationType)annotation);
                    ((ModelAnnotationGroup)FieldSelectionDialog.this.wSelected.getInput()).add((Object)modelAnnotation);
                    FieldSelectionDialog.this.wSelected.refresh();
                }
            }
        });
        this.wRemove.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FieldSelectionDialog.this.removeField();
            }
        });
        this.wRemoveAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationGroup toSelect = new ModelAnnotationGroup();
                for (ModelAnnotation modelAnnotation : (ModelAnnotationGroup)FieldSelectionDialog.this.wSelected.getInput()) {
                    if (modelAnnotation.getType() == ModelAnnotation.Type.CREATE_CALCULATED_MEMBER) continue;
                    toSelect.add((Object)modelAnnotation);
                }
                FieldSelectionDialog.this.wSelected.setSelection((ISelection)new StructuredSelection((List)toSelect), false);
                FieldSelectionDialog.this.removeField();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FieldSelectionDialog.this.modelAnnotations.clear();
                FieldSelectionDialog.this.modelAnnotations.addAll((Collection)((ModelAnnotationGroup)FieldSelectionDialog.this.wSelected.getInput()));
                FieldSelectionDialog.this.dispose();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FieldSelectionDialog.this.dispose();
            }
        });
        this.wSelected.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                FieldSelectionDialog.this.wAvailable.deselectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.wAvailable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ((org.eclipse.swt.widgets.List)FieldSelectionDialog.this.wSelected.getControl()).deselectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.wAvailable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                FieldSelectionDialog.this.addField();
            }
        });
        this.wSelected.getList().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f') {
                    FieldSelectionDialog.this.removeField();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (FieldSelectionDialog.this.lsClose != null) {
                    FieldSelectionDialog.this.lsClose.handleEvent(null);
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                if (FieldSelectionDialog.this.lsClose != null) {
                    FieldSelectionDialog.this.lsClose.handleEvent(null);
                }
            }
        });
    }

    public void onClose(Listener listener) {
        this.lsClose = listener;
    }

    private void removeField() {
        Iterator iterator = ((IStructuredSelection)this.wSelected.getSelection()).iterator();
        ModelAnnotationGroup toRemove = new ModelAnnotationGroup();
        while (iterator.hasNext()) {
            toRemove.add((Object)((ModelAnnotation)iterator.next()));
        }
        ((ModelAnnotationGroup)this.wSelected.getInput()).removeAll((Collection)toRemove);
        this.wSelected.refresh();
    }

    private void addField() {
        for (String field : this.wAvailable.getSelection()) {
            BlankAnnotation annotation = new BlankAnnotation();
            annotation.setField(field);
            ModelAnnotation modelAnnotation = new ModelAnnotation((AnnotationType)annotation);
            ((ModelAnnotationGroup)this.wSelected.getInput()).add((Object)modelAnnotation);
            this.wSelected.refresh();
        }
    }

    private void populateLists() {
        for (ValueMetaInterface valueMetaInterface : this.prevStepFields.getValueMetaList()) {
            if (!StringUtils.isNotBlank((String)valueMetaInterface.getName())) continue;
            this.wAvailable.add(valueMetaInterface.getName());
        }
        this.wSelected.setContentProvider((IContentProvider)new ArrayContentProvider());
        ModelAnnotationGroup input = new ModelAnnotationGroup();
        input.addAll((Collection)this.modelAnnotations);
        this.wSelected.setInput((Object)input);
        this.wSelected.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ModelAnnotation modelAnnotation = (ModelAnnotation)element;
                return modelAnnotation.getField();
            }
        });
        this.wSelected.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object providerData, Object item) {
                return ((ModelAnnotation)item).getType() != ModelAnnotation.Type.CREATE_CALCULATED_MEMBER;
            }
        }});
    }

    private void initializeWidgets() {
        this.wlAvailable = new Label((Composite)this.shell, 0);
        this.wlAvailable.setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.AvailableFields", (String[])new String[0]));
        this.props.setLook((Control)this.wlAvailable);
        this.wlSelected = new Label((Composite)this.shell, 0);
        this.wlSelected.setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.SelectedFields", (String[])new String[0]));
        this.props.setLook((Control)this.wlSelected);
        this.wSelected = new ListViewer((Composite)this.shell, 2818);
        this.props.setLook((Control)this.wSelected.getList());
        this.wAvailable = new org.eclipse.swt.widgets.List((Composite)this.shell, 2818);
        this.props.setLook((Control)this.wAvailable);
        this.wAdd = new Button((Composite)this.shell, 0);
        this.wAdd.setImage(GUIResource.getInstance().getImageAddSingle());
        this.wAdd.setToolTipText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.Add", (String[])new String[0]));
        this.props.setLook((Control)this.wAdd);
        this.wAddAll = new Button((Composite)this.shell, 0);
        this.wAddAll.setImage(GUIResource.getInstance().getImageAddAll());
        this.wAddAll.setToolTipText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.AddAll", (String[])new String[0]));
        this.props.setLook((Control)this.wAddAll);
        this.wRemove = new Button((Composite)this.shell, 0);
        this.wRemove.setImage(GUIResource.getInstance().getImageRemoveSingle());
        this.wRemove.setToolTipText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.Remove", (String[])new String[0]));
        this.props.setLook((Control)this.wRemove);
        this.wRemoveAll = new Button((Composite)this.shell, 0);
        this.wRemoveAll.setImage(GUIResource.getInstance().getImageRemoveAll());
        this.wRemoveAll.setToolTipText(BaseMessages.getString(PKG, (String)"ModelAnnotation.FieldSelectionDialog.RemoveAll", (String[])new String[0]));
        this.props.setLook((Control)this.wRemoveAll);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.props.setLook((Control)this.wOK);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.props.setLook((Control)this.wCancel);
        this.wBottomHorizontalSeparator = new Label((Composite)this.shell, 258);
    }

    private void layoutWidgets() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.shell.setLayout((Layout)layout);
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, -4);
        fdCancel.bottom = new FormAttachment(100, -4);
        this.wCancel.setLayoutData((Object)fdCancel);
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -4, 16384);
        fdOk.top = new FormAttachment((Control)this.wCancel, 0, 128);
        this.wOK.setLayoutData((Object)fdOk);
        FormData fdBottomSeparator = new FormData();
        fdBottomSeparator.left = new FormAttachment(0, 4);
        fdBottomSeparator.right = new FormAttachment(100, -4);
        fdBottomSeparator.bottom = new FormAttachment((Control)this.wOK, -10, 128);
        this.wBottomHorizontalSeparator.setLayoutData((Object)fdBottomSeparator);
        FormData fdAvailableLabel = new FormData();
        fdAvailableLabel.left = new FormAttachment(0, 4);
        fdAvailableLabel.top = new FormAttachment(0, 0);
        fdAvailableLabel.right = new FormAttachment(44);
        this.wlAvailable.setLayoutData((Object)fdAvailableLabel);
        FormData fdSelectedLabel = new FormData();
        fdSelectedLabel.left = new FormAttachment(56, 0);
        fdSelectedLabel.top = new FormAttachment(0, 0);
        fdSelectedLabel.right = new FormAttachment(100, -4);
        this.wlSelected.setLayoutData((Object)fdSelectedLabel);
        FormData fdAvailableList = new FormData();
        fdAvailableList.top = new FormAttachment((Control)this.wlAvailable, 4, 1024);
        fdAvailableList.left = new FormAttachment((Control)this.wlAvailable, 0, 16384);
        fdAvailableList.right = new FormAttachment((Control)this.wlAvailable, 0, 131072);
        fdAvailableList.bottom = new FormAttachment((Control)this.wBottomHorizontalSeparator, -10, 128);
        this.wAvailable.setLayoutData((Object)fdAvailableList);
        FormData fdAdd = new FormData();
        fdAdd.top = new FormAttachment(30);
        fdAdd.left = new FormAttachment((Control)this.wAvailable, 4, 131072);
        fdAdd.right = new FormAttachment(56, -4);
        this.wAdd.setLayoutData((Object)fdAdd);
        this.wAdd.setAlignment(0x1000000);
        FormData fdAddAll = new FormData();
        fdAddAll.top = new FormAttachment((Control)this.wAdd, 4, 1024);
        fdAddAll.left = new FormAttachment((Control)this.wAdd, 0, 16384);
        fdAddAll.right = new FormAttachment((Control)this.wAdd, 0, 131072);
        this.wAddAll.setLayoutData((Object)fdAddAll);
        this.wAddAll.setAlignment(0x1000000);
        FormData fdRemove = new FormData();
        fdRemove.top = new FormAttachment((Control)this.wAddAll, 4, 1024);
        fdRemove.left = new FormAttachment((Control)this.wAddAll, 0, 16384);
        fdRemove.right = new FormAttachment((Control)this.wAddAll, 0, 131072);
        this.wRemove.setLayoutData((Object)fdRemove);
        this.wRemove.setAlignment(0x1000000);
        FormData fdRemoveAll = new FormData();
        fdRemoveAll.top = new FormAttachment((Control)this.wRemove, 4, 1024);
        fdRemoveAll.left = new FormAttachment((Control)this.wRemove, 0, 16384);
        fdRemoveAll.right = new FormAttachment((Control)this.wRemove, 0, 131072);
        this.wRemoveAll.setLayoutData((Object)fdRemoveAll);
        this.wRemoveAll.setAlignment(0x1000000);
        FormData fdSelectedList = new FormData();
        fdSelectedList.top = new FormAttachment((Control)this.wlSelected, 4, 1024);
        fdSelectedList.left = new FormAttachment((Control)this.wlSelected, 0, 16384);
        fdSelectedList.right = new FormAttachment((Control)this.wlSelected, 0, 131072);
        fdSelectedList.bottom = new FormAttachment((Control)this.wAvailable, 0, 1024);
        this.wSelected.getList().setLayoutData((Object)fdSelectedList);
    }
}

