/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.common;

import java.util.HashMap;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.trans.steps.annotation.WarningDialog;

public abstract class BaseComposite
extends Composite {
    private static final Class<?> PKG = BaseComposite.class;
    private LogChannel log;
    private Class<?> localizationPkg = PKG;
    private VariableSpace variables;
    private PropsUI props = PropsUI.getInstance();
    protected final int margin = 4;
    protected final int LEFT_MARGIN_OFFSET = 10;
    protected final int RIGHT_MARGIN_OFFSET = -10;
    protected final int SHELL_MIN_WIDTH = 900;
    protected final int SHELL_MIN_HEIGHT = 570;

    public BaseComposite(Composite composite, int i) {
        super(composite, i);
        this.setLook((Control)this);
    }

    protected void logError(String message, Exception e) {
        if (this.log != null) {
            this.log.logError(message, (Throwable)e);
        }
    }

    public LogChannel getLog() {
        return this.log;
    }

    public void setLog(LogChannel log) {
        this.log = log;
    }

    public Class<?> getLocalizationPkg() {
        return this.localizationPkg;
    }

    public void setLocalizationPkg(Class<?> localizationPkg) {
        this.localizationPkg = localizationPkg;
    }

    public VariableSpace getVariables() {
        return this.variables;
    }

    public void setVariables(VariableSpace variables) {
        this.variables = variables;
    }

    public void showInfo(String title, String message) {
        SpoonInterface spoon = this.getSpoon();
        spoon.messageBox(message, title, false, 3);
    }

    public void showError(String title, String message) {
        HashMap<String, Listener> listenerMap = new HashMap<String, Listener>();
        listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]), new Listener(){

            public void handleEvent(Event event) {
            }
        });
        new WarningDialog(this.getShell(), title, message, listenerMap).open();
    }

    protected SpoonInterface getSpoon() {
        return SpoonFactory.getInstance();
    }

    protected void setDefaultRowLayout() {
        RowLayout layout = new RowLayout(512);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        this.setLayout((Layout)layout);
    }

    protected void setLook(Control control) {
        this.props.setLook(control);
    }
}

