/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.ConfiguredYarnAuthorizer;
import org.apache.hadoop.yarn.security.Permission;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class YarnAuthorizationProvider {
    private static final Log LOG = LogFactory.getLog(YarnAuthorizationProvider.class);
    private static YarnAuthorizationProvider authorizer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YarnAuthorizationProvider getInstance(Configuration conf) {
        Class<YarnAuthorizationProvider> clazz = YarnAuthorizationProvider.class;
        synchronized (YarnAuthorizationProvider.class) {
            if (authorizer == null) {
                Class authorizerClass = conf.getClass("yarn.authorization-provider", ConfiguredYarnAuthorizer.class);
                authorizer = (YarnAuthorizationProvider)ReflectionUtils.newInstance((Class)authorizerClass, (Configuration)conf);
                authorizer.init(conf);
                LOG.info((Object)(authorizerClass.getName() + " is instiantiated."));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return authorizer;
        }
    }

    public abstract void init(Configuration var1);

    public abstract boolean checkPermission(AccessRequest var1);

    public abstract void setPermission(List<Permission> var1, UserGroupInformation var2);

    public abstract void setAdmins(AccessControlList var1, UserGroupInformation var2);

    public abstract boolean isAdmin(UserGroupInformation var1);
}

