/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.StringHelper;

@InterfaceAudience.Private
public class ConverterUtils {
    public static final String APPLICATION_PREFIX = "application";
    public static final String CONTAINER_PREFIX = "container";
    public static final String APPLICATION_ATTEMPT_PREFIX = "appattempt";

    public static Path getPathFromYarnURL(URL url) throws URISyntaxException {
        String scheme = url.getScheme() == null ? "" : url.getScheme();
        String authority = "";
        if (url.getHost() != null) {
            authority = url.getHost();
            if (url.getUserInfo() != null) {
                authority = url.getUserInfo() + "@" + authority;
            }
            if (url.getPort() > 0) {
                authority = authority + ":" + url.getPort();
            }
        }
        return new Path(new URI(scheme, authority, url.getFile(), null, null).normalize());
    }

    public static Map<String, String> convertToString(Map<CharSequence, CharSequence> env) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : env.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    public static URL getYarnUrlFromPath(Path path) {
        return ConverterUtils.getYarnUrlFromURI(path.toUri());
    }

    public static URL getYarnUrlFromURI(URI uri) {
        URL url = (URL)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(URL.class);
        if (uri.getHost() != null) {
            url.setHost(uri.getHost());
        }
        if (uri.getUserInfo() != null) {
            url.setUserInfo(uri.getUserInfo());
        }
        url.setPort(uri.getPort());
        url.setScheme(uri.getScheme());
        url.setFile(uri.getPath());
        return url;
    }

    public static String toString(ApplicationId appId) {
        return appId.toString();
    }

    public static ApplicationId toApplicationId(RecordFactory recordFactory, String appIdStr) {
        Iterator<String> it = StringHelper._split(appIdStr).iterator();
        if (!it.next().equals(APPLICATION_PREFIX)) {
            throw new IllegalArgumentException("Invalid ApplicationId prefix: " + appIdStr + ". The valid ApplicationId should start with prefix " + APPLICATION_PREFIX);
        }
        try {
            return ConverterUtils.toApplicationId(recordFactory, it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, n);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, e);
        }
    }

    private static ApplicationId toApplicationId(RecordFactory recordFactory, Iterator<String> it) {
        ApplicationId appId = ApplicationId.newInstance((long)Long.parseLong(it.next()), (int)Integer.parseInt(it.next()));
        return appId;
    }

    private static ApplicationAttemptId toApplicationAttemptId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = ApplicationId.newInstance((long)Long.parseLong(it.next()), (int)Integer.parseInt(it.next()));
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)Integer.parseInt(it.next()));
        return appAttemptId;
    }

    private static ApplicationId toApplicationId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = ApplicationId.newInstance((long)Long.parseLong(it.next()), (int)Integer.parseInt(it.next()));
        return appId;
    }

    public static String toString(ContainerId cId) {
        return cId == null ? null : cId.toString();
    }

    public static NodeId toNodeIdWithDefaultPort(String nodeIdStr) {
        if (nodeIdStr.indexOf(":") < 0) {
            return ConverterUtils.toNodeId(nodeIdStr + ":0");
        }
        return ConverterUtils.toNodeId(nodeIdStr);
    }

    public static NodeId toNodeId(String nodeIdStr) {
        String[] parts = nodeIdStr.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid NodeId [" + nodeIdStr + "]. Expected host:port");
        }
        try {
            NodeId nodeId = NodeId.newInstance((String)parts[0].trim(), (int)Integer.parseInt(parts[1]));
            return nodeId;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port: " + parts[1], e);
        }
    }

    public static ContainerId toContainerId(String containerIdStr) {
        return ContainerId.fromString((String)containerIdStr);
    }

    public static ApplicationAttemptId toApplicationAttemptId(String applicationAttmeptIdStr) {
        Iterator<String> it = StringHelper._split(applicationAttmeptIdStr).iterator();
        if (!it.next().equals(APPLICATION_ATTEMPT_PREFIX)) {
            throw new IllegalArgumentException("Invalid AppAttemptId prefix: " + applicationAttmeptIdStr);
        }
        try {
            return ConverterUtils.toApplicationAttemptId(it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + applicationAttmeptIdStr, n);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + applicationAttmeptIdStr, e);
        }
    }

    public static ApplicationId toApplicationId(String appIdStr) {
        Iterator<String> it = StringHelper._split(appIdStr).iterator();
        if (!it.next().equals(APPLICATION_PREFIX)) {
            throw new IllegalArgumentException("Invalid ApplicationId prefix: " + appIdStr + ". The valid ApplicationId should start with prefix " + APPLICATION_PREFIX);
        }
        try {
            return ConverterUtils.toApplicationId(it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, n);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, e);
        }
    }

    public static <T extends TokenIdentifier> Token<T> convertFromYarn(org.apache.hadoop.yarn.api.records.Token protoToken, InetSocketAddress serviceAddr) {
        Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
        if (serviceAddr != null) {
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddr);
        }
        return token;
    }

    public static <T extends TokenIdentifier> Token<T> convertFromYarn(org.apache.hadoop.yarn.api.records.Token protoToken, Text service) {
        Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
        if (service != null) {
            token.setService(service);
        }
        return token;
    }
}

