/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.region.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.karaf.region.commands.RegionCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Command(scope="region", name="filter-add", description="Adds a filter between two regions.")
public class AddFilterCommand
extends RegionCommandSupport {
    @Argument(index=0, name="from", description="The from region.", required=true, multiValued=false)
    String fromRegion;
    @Argument(index=1, name="to", description="The to region.", required=true, multiValued=false)
    String toRegion;
    @Argument(index=2, name="items", description="The bundles by id and packages with version to allow.", required=false, multiValued=true)
    List<String> items;

    @Override
    protected void doExecute(RegionDigraph regionDigraph) throws Exception {
        Region rFrom = this.getRegion(regionDigraph, this.fromRegion);
        Region rTo = this.getRegion(regionDigraph, this.toRegion);
        RegionFilterBuilder builder = regionDigraph.createRegionFilterBuilder();
        BundleContext framework = this.getBundleContext().getBundle(0L).getBundleContext();
        if (this.items != null) {
            for (String item : this.items) {
                try {
                    long id = Long.parseLong(item);
                    Bundle b = framework.getBundle(id);
                    builder.allow("osgi.wiring.bundle", "(osgi.wiring.bundle=" + b.getSymbolicName() + ")");
                }
                catch (NumberFormatException e) {
                    for (Map.Entry parsed : ManifestHeaderProcessor.parseImportString((String)item).entrySet()) {
                        String packageName = (String)parsed.getKey();
                        HashMap<String, String> attributes = new HashMap<String, String>((Map)parsed.getValue());
                        attributes.put("osgi.wiring.package", packageName);
                        String filter = AddFilterCommand.generateFilter(attributes);
                        System.out.println("adding filter " + filter);
                        builder.allow("osgi.wiring.package", filter);
                    }
                }
            }
        }
        RegionFilter f = builder.build();
        regionDigraph.connect(rFrom, f, rTo);
    }

    public static String generateFilter(Map<String, String> attribs) {
        StringBuilder filter = new StringBuilder("(&");
        boolean realAttrib = false;
        StringBuffer realAttribs = new StringBuffer();
        if (attribs == null) {
            attribs = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> attrib : attribs.entrySet()) {
            String attribName = attrib.getKey();
            if (attribName.endsWith(":")) continue;
            if ("version".equals(attribName) || "bundle-version".equals(attribName)) {
                realAttrib = true;
                VersionRange vr = ManifestHeaderProcessor.parseVersionRange((String)attrib.getValue());
                filter.append("(" + attribName + ">=" + vr.getMinimumVersion());
                if (vr.getMaximumVersion() != null) {
                    filter.append(")(" + attribName + "<=");
                    filter.append(vr.getMaximumVersion());
                }
                if (vr.getMaximumVersion() != null && vr.isMinimumExclusive()) {
                    filter.append(")(!(" + attribName + "=");
                    filter.append(vr.getMinimumVersion());
                    filter.append(")");
                }
                if (vr.getMaximumVersion() != null && vr.isMaximumExclusive()) {
                    filter.append(")(!(" + attribName + "=");
                    filter.append(vr.getMaximumVersion());
                    filter.append(")");
                }
                filter.append(")");
                continue;
            }
            if ("objectClass".equals(attribName)) {
                String[] values;
                realAttrib = true;
                for (String s : values = attrib.getValue().split(",")) {
                    filter.append("(objectClass=" + s + ")");
                }
                continue;
            }
            realAttrib = true;
            filter.append("(" + attribName + "=" + attrib.getValue() + ")");
            if ("bundle-symbolic-name".equals(attribName)) continue;
            realAttribs.append(attribName);
            realAttribs.append(", ");
        }
        String filterString = filter.toString();
        int openBraces = 0;
        int i = 0;
        while (openBraces < 3 && (i = filterString.indexOf(40, i)) != -1) {
            ++openBraces;
            ++i;
        }
        if (openBraces < 3 && filterString.length() > 2) {
            filter.delete(0, 2);
        } else {
            filter.append(")");
        }
        String result = "";
        if (realAttrib) {
            result = filter.toString();
        }
        return result;
    }
}

