/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.wizard.model.LengthUnit;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public final class Length
implements Serializable {
    private double value;
    private LengthUnit unit;

    public Length(LengthUnit unit, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public Float getNormalizedValue() {
        return new Float(this.unit.convertToPoints(this.value));
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Length)) {
            return false;
        }
        Length length = (Length)o;
        if (Double.compare(length.value, this.value) != 0) {
            return false;
        }
        return this.unit.equals(length.unit);
    }

    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public static Length parseLength(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        try {
            LengthUnit[] lengthUnits = LengthUnit.values();
            for (int i = 0; i < lengthUnits.length; ++i) {
                LengthUnit lengthUnit = lengthUnits[i];
                String name = lengthUnit.getName();
                if (!StringUtils.endsWithIgnoreCase((String)s, (String)name)) continue;
                String number = s.substring(0, s.length() - name.length()).trim();
                double v = Double.parseDouble(number.trim());
                return new Length(lengthUnit, v);
            }
            double v = Double.parseDouble(s.trim());
            return new Length(LengthUnit.POINTS, v);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Length '" + s + "' cannot be parsed.");
        }
    }

    public String toString() {
        FastDecimalFormat numberInstance = new FastDecimalFormat("#0.####", Locale.US);
        return numberInstance.format((Object)new BigDecimal(this.value)) + this.unit.getName();
    }
}

