/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.parser;

import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultDetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.DetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.Length;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DetailsFieldDefinitionReadHandler
extends AbstractXmlReadHandler {
    private DetailFieldDefinition detailField = new DefaultDetailFieldDefinition();

    protected void startParsing(Attributes attrs) throws SAXException {
        String hAlightAttr = attrs.getValue(this.getUri(), "horizontal-align");
        this.detailField.setHorizontalAlignment(ReportParserUtil.parseHorizontalElementAlignment((String)hAlightAttr, (Locator)this.getLocator()));
        String vAlightAttr = attrs.getValue(this.getUri(), "vertical-align");
        this.detailField.setVerticalAlignment(ReportParserUtil.parseVerticalElementAlignment((String)vAlightAttr, (Locator)this.getLocator()));
        String colorAttr = attrs.getValue(this.getUri(), "font-color");
        String backgroundColorAttr = attrs.getValue(this.getUri(), "background-color");
        this.detailField.setFontColor(ReportParserUtil.parseColor((String)colorAttr, null));
        this.detailField.setBackgroundColor(ReportParserUtil.parseColor((String)backgroundColorAttr, null));
        this.detailField.setFontName(attrs.getValue(this.getUri(), "font-name"));
        String fontSizeAttr = attrs.getValue(this.getUri(), "font-size");
        this.detailField.setFontSize(ReportParserUtil.parseInteger((String)fontSizeAttr, (Locator)this.getLocator()));
        String boldAttr = attrs.getValue(this.getUri(), "bold");
        this.detailField.setFontBold(ParserUtil.parseBoolean((String)boldAttr, (Locator)this.getLocator()));
        String italicAttr = attrs.getValue(this.getUri(), "italic");
        this.detailField.setFontItalic(ParserUtil.parseBoolean((String)italicAttr, (Locator)this.getLocator()));
        String underlineAttr = attrs.getValue(this.getUri(), "underline");
        this.detailField.setFontUnderline(ParserUtil.parseBoolean((String)underlineAttr, (Locator)this.getLocator()));
        String strikethroughAttr = attrs.getValue(this.getUri(), "strikethrough");
        this.detailField.setFontStrikethrough(ParserUtil.parseBoolean((String)strikethroughAttr, (Locator)this.getLocator()));
        this.detailField.setNullString(attrs.getValue(this.getUri(), "null-string"));
        String displayName = attrs.getValue(this.getUri(), "display-name");
        this.detailField.setDisplayName(displayName);
        this.detailField.setField(attrs.getValue(this.getUri(), "field"));
        this.detailField.setDataFormat(attrs.getValue(this.getUri(), "data-format"));
        String aggFunctionName = attrs.getValue(this.getUri(), "aggregation-function");
        if (aggFunctionName != null) {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(DetailsFieldDefinitionReadHandler.class);
            try {
                Class<?> c = Class.forName(aggFunctionName, false, classLoader);
                if (!Expression.class.isAssignableFrom(c)) {
                    throw new ParseException("Failed to parse attribute 'aggregation-function': invalid class name");
                }
                this.detailField.setAggregationFunction(c);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Failed to parse attribute 'aggregation-function': invalid class name", (Exception)e);
            }
        }
        String widthAttr = attrs.getValue(this.getUri(), "width");
        this.detailField.setWidth(Length.parseLength(widthAttr));
        String onlyDistinctAttr = attrs.getValue(this.getUri(), "only-show-distinct");
        this.detailField.setOnlyShowChangingValues(ParserUtil.parseBoolean((String)onlyDistinctAttr, (Locator)this.getLocator()));
    }

    public Object getObject() throws SAXException {
        return this.detailField;
    }
}

