/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.parser;

import org.pentaho.reporting.engine.classic.wizard.model.DefaultWizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.model.GroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.parser.DetailsFieldDefinitionsReadHandler;
import org.pentaho.reporting.engine.classic.wizard.parser.GroupDefinitionsReadHandler;
import org.pentaho.reporting.engine.classic.wizard.parser.RootBandDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.wizard.parser.WatermarkDefinitionReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WizardSpecificationReadHandler
extends AbstractXmlReadHandler {
    private WizardSpecification wizardSpecification;
    private GroupDefinitionsReadHandler groupDefinitionsReadHandler;
    private DetailsFieldDefinitionsReadHandler detailsFieldDefinitionsReadHandler;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.wizardSpecification = new DefaultWizardSpecification();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("column-footer".equals(tagName)) {
            return new RootBandDefinitionReadHandler(this.wizardSpecification.getColumnFooter());
        }
        if ("column-header".equals(tagName)) {
            return new RootBandDefinitionReadHandler(this.wizardSpecification.getColumnHeader());
        }
        if ("watermark-specification".equals(tagName)) {
            return new WatermarkDefinitionReadHandler(this.wizardSpecification.getWatermarkDefinition());
        }
        if ("group-definitions".equals(tagName)) {
            this.groupDefinitionsReadHandler = new GroupDefinitionsReadHandler();
            return this.groupDefinitionsReadHandler;
        }
        if ("detail-fields".equals(tagName)) {
            this.detailsFieldDefinitionsReadHandler = new DetailsFieldDefinitionsReadHandler();
            return this.detailsFieldDefinitionsReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.groupDefinitionsReadHandler != null) {
            GroupDefinition[] groupDefinitions = this.groupDefinitionsReadHandler.getGroupDefinitions();
            this.wizardSpecification.setGroupDefinitions(groupDefinitions);
        }
        if (this.detailsFieldDefinitionsReadHandler != null) {
            this.wizardSpecification.setDetailFieldDefinitions(this.detailsFieldDefinitionsReadHandler.getDetailFieldDefinitions());
        }
    }

    public Object getObject() throws SAXException {
        return this.wizardSpecification;
    }
}

