/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.engine.classic.extensions.drilldown.LinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.ParameterEntry;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.TypeUtil;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class DrillDownFunction
implements Function {
    private static final Log logger = LogFactory.getLog(DrillDownFunction.class);

    public String getCanonicalName() {
        return "DRILLDOWN";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        String path;
        if (parameters.getParameterCount() != 3) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String configIndicator = typeRegistry.convertToText(parameters.getType(0), parameters.getValue(0));
        try {
            path = typeRegistry.convertToText(parameters.getType(1), parameters.getValue(1));
        }
        catch (EvaluationException ee) {
            if (LibFormulaErrorValue.ERROR_NA_VALUE.equals((Object)ee.getErrorValue())) {
                path = null;
            }
            throw ee;
        }
        ArrayCallback parameter = typeRegistry.convertToArray(parameters.getType(2), parameters.getValue(2));
        LinkCustomizer pattern = this.createLinkCustomizer(configIndicator);
        return new TypeValuePair((Type)TextType.TYPE, (Object)pattern.format(context, configIndicator, path, this.computeParameterEntries(parameter, typeRegistry)));
    }

    private ParameterEntry[] computeParameterEntries(ArrayCallback paraCallback, TypeRegistry typeRegistry) throws EvaluationException {
        if (paraCallback.getColumnCount() == 0) {
            return new ParameterEntry[0];
        }
        if (paraCallback.getColumnCount() != 2) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int rowCount = paraCallback.getRowCount();
        ParameterEntry[] retval = new ParameterEntry[rowCount];
        for (int r = 0; r < rowCount; ++r) {
            String name = typeRegistry.convertToText(paraCallback.getType(r, 0), paraCallback.getValue(r, 0));
            try {
                Object value = paraCallback.getValue(r, 1);
                if (value instanceof ArrayCallback) {
                    retval[r] = new ParameterEntry(name, TypeUtil.normalize((ArrayCallback)((ArrayCallback)value)));
                    continue;
                }
                if (value instanceof Sequence) {
                    retval[r] = new ParameterEntry(name, TypeUtil.normalize((Sequence)((Sequence)value)));
                    continue;
                }
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    retval[r] = new ParameterEntry(name, c.toArray());
                    continue;
                }
                retval[r] = new ParameterEntry(name, value);
                continue;
            }
            catch (EvaluationException ee) {
                if (ee.getErrorValue() == LibFormulaErrorValue.ERROR_NA_VALUE) {
                    retval[r] = new ParameterEntry(name, null);
                    continue;
                }
                throw ee;
            }
        }
        return retval;
    }

    private LinkCustomizer createLinkCustomizer(String configIndicator) throws EvaluationException {
        DrillDownProfile downProfile = DrillDownProfileMetaData.getInstance().getDrillDownProfile(configIndicator);
        if (downProfile == null) {
            logger.warn((Object)String.format("Referenced drilldown profile %s does not exist.", configIndicator));
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        try {
            return (LinkCustomizer)downProfile.getLinkCustomizerType().newInstance();
        }
        catch (InstantiationException e) {
            logger.warn((Object)String.format("Failed to instantiate profile %s.", configIndicator), (Throwable)e);
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)String.format("Failed to instantiate profile %s.", configIndicator), (Throwable)e);
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }
}

