/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.util.ResourceBundle;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.function.formula.DashboardModeFunction;
import org.pentaho.reporting.engine.classic.core.function.formula.QuoteTextFunction;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class OpenInMantleTabFunction
implements Function {
    public String getCanonicalName() {
        return "OPENINMANTLETAB";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() < 1) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        if (parameters.getParameterCount() > 3) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String urlText = typeRegistry.convertToText(parameters.getType(0), parameters.getValue(0));
        if (urlText == null) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        String tabText = null;
        if (parameters.getParameterCount() > 1) {
            tabText = typeRegistry.convertToText(parameters.getType(1), parameters.getValue(1));
        }
        ReportFormulaContext rfc = (ReportFormulaContext)context;
        if (StringUtils.isEmpty(tabText)) {
            Object o;
            DocumentMetaData documentMetaData = rfc.getProcessingContext().getDocumentMetaData();
            tabText = (String)documentMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title");
            if (StringUtils.isEmpty((String)tabText) && (o = rfc.getDataRow().get("report.name")) != null) {
                tabText = String.valueOf(o);
            }
            if (StringUtils.isEmpty((String)tabText)) {
                ResourceBundle bundle = ResourceBundle.getBundle("org.pentaho.reporting.engine.classic.extensions.drilldown.messages");
                tabText = bundle.getString("UnnamedTab");
            }
        }
        boolean tabActive = parameters.getParameterCount() == 3 ? !Boolean.FALSE.equals(typeRegistry.convertToLogical(parameters.getType(2), parameters.getValue(2))) : true;
        if (tabActive && this.isTabPossible(rfc)) {
            StringBuffer b = new StringBuffer();
            b.append("javascript:top.mantle_openTab('");
            b.append(QuoteTextFunction.saveConvert((String)tabText));
            b.append("','");
            b.append(QuoteTextFunction.saveConvert((String)tabText));
            b.append("','");
            b.append(QuoteTextFunction.saveConvert((String)urlText));
            b.append("')");
            return new TypeValuePair((Type)TextType.TYPE, (Object)b.toString());
        }
        return new TypeValuePair((Type)TextType.TYPE, (Object)urlText);
    }

    private boolean isTabPossible(ReportFormulaContext rfc) {
        if (DashboardModeFunction.isDashboardMode((ReportFormulaContext)rfc)) {
            return false;
        }
        String exportType = rfc.getExportType();
        return exportType.startsWith("table/html") && !"application/zip;content=table/html;page-mode=flow".equals(exportType);
    }
}

