/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.extensions.drilldown.FormulaLinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.ParameterEntry;
import org.pentaho.reporting.engine.classic.extensions.drilldown.PentahoPathNormalizerFunction;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;

public class SugarFormulaLinkCustomizer
extends FormulaLinkCustomizer {
    private static final String PENTAHO_PATH = "::pentaho-path";

    private String computePentahoPath(ParameterEntry[] entries) throws EvaluationException {
        for (int i = 0; i < entries.length; ++i) {
            Object o;
            ParameterEntry parameterEntry = entries[i];
            String parameterName = parameterEntry.getParameterName();
            if (!PENTAHO_PATH.equals(parameterName) || (o = parameterEntry.getParameterValue()) == null) continue;
            return PentahoPathNormalizerFunction.normalizePath(String.valueOf(o));
        }
        return null;
    }

    @Override
    protected Map<String, Object> createParameterMap(FormulaContext formulaContext, String configIndicator, String reportPath, ParameterEntry[] entries) throws UnsupportedEncodingException, BeanException, EvaluationException {
        Map<String, Object> parameterMap = super.createParameterMap(formulaContext, configIndicator, reportPath, entries);
        parameterMap.put(PENTAHO_PATH, this.computePentahoPath(entries));
        return parameterMap;
    }

    @Override
    public String format(FormulaContext formulaContext, String configIndicator, String reportPath, ParameterEntry[] entries) throws EvaluationException {
        return super.format(formulaContext, configIndicator, reportPath, entries);
    }

    @Override
    protected boolean isFiltered(ParameterEntry entry) {
        if (PENTAHO_PATH.equals(entry.getParameterName())) {
            return true;
        }
        if ("path".equals(entry.getParameterName())) {
            return true;
        }
        if ("name".equals(entry.getParameterName())) {
            return true;
        }
        if ("solution".equals(entry.getParameterName())) {
            return true;
        }
        if ("action".equals(entry.getParameterName())) {
            return true;
        }
        return super.isFiltered(entry);
    }
}

