/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.LinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.PatternLinkCustomizer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DrillDownProfileReadHandler
extends AbstractMetaDataReadHandler {
    private ArrayList<PropertyReadHandler> attributes;
    private Class linkCustomizerType;
    private String prefix;
    private String group;

    public DrillDownProfileReadHandler(String group) {
        this.group = group;
        this.attributes = new ArrayList();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        block5: {
            super.startParsing(attrs);
            String valueTypeText = attrs.getValue(this.getUri(), "class");
            if (valueTypeText != null) {
                try {
                    ClassLoader loader = ObjectUtilities.getClassLoader(DrillDownProfileReadHandler.class);
                    this.linkCustomizerType = Class.forName(valueTypeText, false, loader);
                    if (!LinkCustomizer.class.isAssignableFrom(this.linkCustomizerType)) {
                        throw new ParseException("Attribute 'class' is not valid", this.getLocator());
                    }
                    break block5;
                }
                catch (ParseException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
                }
            }
            this.linkCustomizerType = PatternLinkCustomizer.class;
        }
        this.prefix = "drilldown-profile.";
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("attribute".equals(tagName)) {
            PropertyReadHandler propertyReadHandler = new PropertyReadHandler();
            this.attributes.add(propertyReadHandler);
            return propertyReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    public Object getObject() throws SAXException {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            PropertyReadHandler readHandler = this.attributes.get(i);
            attrMap.put(readHandler.getName(), readHandler.getResult());
        }
        attrMap.put("group", this.group);
        return new DrillDownProfile(this.getName(), this.getBundle(), this.prefix, this.isExpert(), this.isPreferred(), this.isHidden(), this.isDeprecated(), this.linkCustomizerType, attrMap, this.getMaturityLevel(), -1);
    }
}

