/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.webservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.pentaho.osgi.i18n.LocalizationService;
import org.pentaho.osgi.i18n.webservice.ResourceBundleRequest;
import org.pentaho.osgi.i18n.webservice.ResourceBundleWildcard;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@WebService
public class LocalizationWebservice
implements LocalizationService {
    private LocalizationService localizationService;

    public ResourceBundle getResourceBundle(String name, Locale locale) {
        return this.localizationService.getResourceBundle(name, locale);
    }

    public List<ResourceBundle> getResourceBundles(Pattern keyRegex, Locale locale) {
        return this.localizationService.getResourceBundles(keyRegex, locale);
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    @GET
    @Path(value="/{key}/{language}")
    public ResourceBundle getResourceBundleService(@PathParam(value="key") String key, @PathParam(value="language") String localeString) {
        return this.getResourceBundle(key, LocalizationWebservice.getLocale(localeString));
    }

    private static Locale getLocale(String localeString) {
        String[] splitLocale = localeString == null || localeString.trim().length() == 0 ? new String[]{} : localeString.split("_");
        Locale locale = splitLocale.length == 1 ? new Locale(splitLocale[0]) : (splitLocale.length >= 2 ? new Locale(splitLocale[0], splitLocale[1]) : Locale.getDefault());
        return locale;
    }

    @POST
    @Path(value="/wildcard")
    public ResourceBundle getResourceBundle(ResourceBundleRequest resourceBundleRequest) {
        final ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (ResourceBundleWildcard resourceBundleWildcard : resourceBundleRequest.getWildcards()) {
            Pattern keyPattern = Pattern.compile(resourceBundleWildcard.getKeyRegex());
            resourceBundles.addAll(this.getResourceBundles(keyPattern, LocalizationWebservice.getLocale(resourceBundleRequest.getLocale())));
        }
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                ArrayList<Object[]> entries = new ArrayList<Object[]>();
                for (ResourceBundle resourceBundle : resourceBundles) {
                    for (String key : Collections.list(resourceBundle.getKeys())) {
                        entries.add(new Object[]{key, resourceBundle.getString(key)});
                    }
                }
                return (Object[][])entries.toArray((T[])new Object[entries.size()][]);
            }
        };
    }
}

