/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.commons.handler;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.url.commons.handler.ConnectionFactory;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerActivator<T>
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerActivator.class);
    private final String[] m_protocols;
    private final String m_pid;
    private final ConnectionFactory<T> m_connectionFactory;
    private BundleContext m_bundleContext;
    private PropertyResolver m_propertyResolver;
    private T m_configuration;
    private ServiceRegistration m_handlerReg;
    private ServiceRegistration m_managedServiceReg;

    public HandlerActivator(String[] protocols, String pid, ConnectionFactory<T> connectionFactory) {
        NullArgumentException.validateNotNull((Object)protocols, (String)"Protocols");
        NullArgumentException.validateNotNull((Object)pid, (String)"PID");
        NullArgumentException.validateNotNull(connectionFactory, (String)"Connection factory");
        this.m_protocols = protocols;
        this.m_pid = pid;
        this.m_connectionFactory = connectionFactory;
    }

    public void start(BundleContext bundleContext) {
        NullArgumentException.validateNotNull((Object)bundleContext, (String)"Bundle context");
        this.m_bundleContext = bundleContext;
        this.m_propertyResolver = new BundleContextPropertyResolver(bundleContext);
        this.m_configuration = this.m_connectionFactory.createConfiguration(this.m_propertyResolver);
        this.registerHandler();
        this.registerManagedService();
        LOG.debug("Handler for protocols " + Arrays.deepToString(this.m_protocols) + " started");
    }

    public void stop(BundleContext bundleContext) {
        NullArgumentException.validateNotNull((Object)bundleContext, (String)"Bundle context");
        if (this.m_handlerReg != null) {
            this.m_handlerReg.unregister();
            this.m_handlerReg = null;
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
            this.m_managedServiceReg = null;
        }
        this.m_bundleContext = null;
        LOG.debug("Handler for protocols " + Arrays.deepToString(this.m_protocols) + " stopped");
    }

    private void registerHandler() {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("url.handler.protocol", this.m_protocols);
        this.m_handlerReg = this.m_bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new Handler(), props);
    }

    private void registerManagedService() {
        try {
            ManagedService managedService = new ManagedService(){

                public void updated(Dictionary config) throws ConfigurationException {
                    if (config == null) {
                        HandlerActivator.this.setResolver((PropertyResolver)new BundleContextPropertyResolver(HandlerActivator.this.m_bundleContext));
                    } else {
                        HandlerActivator.this.setResolver((PropertyResolver)new DictionaryPropertyResolver(config));
                    }
                }
            };
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", this.m_pid);
            this.m_managedServiceReg = this.m_bundleContext.registerService(ManagedService.class.getName(), (Object)managedService, props);
        }
        catch (Throwable ignore) {
            this.setResolver((PropertyResolver)new BundleContextPropertyResolver(this.m_bundleContext));
            this.m_managedServiceReg = null;
        }
    }

    synchronized PropertyResolver getResolver() {
        return this.m_propertyResolver;
    }

    synchronized void setResolver(PropertyResolver propertyResolver) {
        this.m_propertyResolver = propertyResolver;
        this.m_configuration = this.m_connectionFactory.createConfiguration(propertyResolver);
    }

    private class Handler
    extends AbstractURLStreamHandlerService {
        private Handler() {
        }

        public URLConnection openConnection(URL url) throws IOException {
            return HandlerActivator.this.m_connectionFactory.createConection(HandlerActivator.this.m_bundleContext, url, HandlerActivator.this.m_configuration);
        }
    }
}

