/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.reader;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.exception.JsonInputException;
import org.pentaho.di.trans.steps.jsoninput.reader.IJsonReader;

public class FastJsonReader
implements IJsonReader {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String JSON_CHARSET = "UTF-8";
    private ReadContext jsonReadContext;
    private Configuration jsonConfiguration = Configuration.defaultConfiguration().addOptions(DEFAULT_OPTIONS);
    private boolean ignoreMissingPath = false;
    private JsonInputField[] fields;
    private JsonPath[] paths = null;
    private LogChannelInterface log;
    private static final Option[] DEFAULT_OPTIONS = new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST, Option.DEFAULT_PATH_LEAF_TO_NULL};

    protected FastJsonReader(LogChannelInterface log) throws KettleException {
        this.log = log;
    }

    public FastJsonReader(JsonInputField[] fields, LogChannelInterface log) throws KettleException {
        this(log);
        this.fields = fields;
        this.paths = FastJsonReader.compilePaths(fields);
    }

    @Override
    public void setIgnoreMissingPath(boolean value) {
        this.ignoreMissingPath = value;
    }

    private ParseContext getParseContext() {
        return JsonPath.using((Configuration)this.jsonConfiguration);
    }

    private ReadContext getReadContext() {
        return this.jsonReadContext;
    }

    private static JsonPath[] compilePaths(JsonInputField[] fields) {
        JsonPath[] paths = new JsonPath[fields.length];
        int i = 0;
        for (JsonInputField field : fields) {
            paths[i++] = JsonPath.compile((String)field.getPath(), (Predicate[])new Predicate[0]);
        }
        return paths;
    }

    protected void readInput(InputStream is) throws KettleException {
        this.jsonReadContext = this.getParseContext().parse(is, JSON_CHARSET);
        if (this.jsonReadContext == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
        }
    }

    @Override
    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    @Override
    public void setFields(JsonInputField[] fields) throws KettleException {
        this.fields = fields;
        this.paths = FastJsonReader.compilePaths(fields);
    }

    @Override
    public RowSet parse(InputStream in) throws KettleException {
        this.readInput(in);
        List<Object[]> results = this.evalCombinedResult();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.NrRecords", (Object[])new Object[]{results.size()}));
        }
        return new TransposedRowSet(results);
    }

    private List<Object[]> evalCombinedResult() throws JsonInputException {
        int lastSize = -1;
        String prevPath = null;
        ArrayList inputs = new ArrayList(this.paths.length);
        int i = 0;
        for (JsonPath path : this.paths) {
            List input = (List)this.getReadContext().read(path);
            if (input.size() != lastSize && lastSize > 0 & input.size() != 0) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonInput.Error.BadStructure", (Object[])new Object[]{input.size(), this.fields[i].getPath(), prevPath, lastSize}));
            }
            if ((FastJsonReader.isAllNull(input) || input.size() == 0) && !this.isIgnoreMissingPath()) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{this.fields[i].getPath()}));
            }
            inputs.add(input);
            lastSize = input.size();
            prevPath = this.fields[i].getPath();
            ++i;
        }
        List<Object[]> resultRows = this.convertInputsIntoResultRows(inputs);
        this.filterOutExcessRows(resultRows);
        if (!this.ignoreMissingPath & this.paths.length != 0) {
            this.raiseExceptionIfAnyMissingPath(resultRows);
        }
        return resultRows;
    }

    private List<Object[]> convertInputsIntoResultRows(List<List<?>> inputs) {
        ArrayList<Object> resultRows = null;
        if (inputs.isEmpty()) {
            resultRows = new ArrayList<Object[]>(1);
            resultRows.add(new Object[0]);
            return resultRows;
        }
        int rowCount = inputs.stream().max(Comparator.comparingInt(List::size)).get().size();
        resultRows = new ArrayList(rowCount);
        Object[] resultRow = null;
        for (int rownum = 0; rownum < rowCount; ++rownum) {
            resultRow = new Object[inputs.size()];
            for (int col = 0; col < inputs.size(); ++col) {
                resultRow[col] = inputs.get(col).size() == 0 ? null : inputs.get(col).get(rownum);
            }
            resultRows.add(resultRow);
        }
        return resultRows;
    }

    private void filterOutExcessRows(List<Object[]> resultRows) {
        boolean atLeastOneNonNull = resultRows.stream().anyMatch(el -> Arrays.stream(el).anyMatch(in -> in != null));
        if (!atLeastOneNonNull) {
            resultRows.clear();
            resultRows.add(new Object[0]);
            return;
        }
        resultRows.removeIf(el -> Arrays.stream(el).allMatch(in -> in == null));
    }

    private void raiseExceptionIfAnyMissingPath(List<Object[]> resultRows) throws JsonInputException {
        for (Object[] resultRow : resultRows) {
            for (int i = 0; i < resultRow.length; ++i) {
                if (resultRow[i] != null) continue;
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{this.fields[i].getPath()}));
            }
        }
    }

    public static boolean isAllNull(Iterable<?> list) {
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    private static class TransposedRowSet
    extends SingleRowRowSet {
        private List<Object[]> results;

        public TransposedRowSet(List<Object[]> results) {
            this.results = results;
        }

        public Object[] getRow() {
            if (!this.results.isEmpty()) {
                return this.results.remove(0);
            }
            return null;
        }

        public int size() {
            return this.results.size();
        }

        public boolean isDone() {
            return true;
        }

        public void clear() {
            this.results.clear();
        }
    }
}

