/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(AppBlock.class);
    protected ApplicationBaseProtocol appBaseProt;
    protected Configuration conf;
    protected ApplicationId appID = null;

    @Inject
    protected AppBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx, Configuration conf) {
        super(ctx);
        this.appBaseProt = appBaseProt;
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        Collection attempts;
        ApplicationReport appReport;
        String webUiType = this.$("web.ui.type");
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires Application ID"});
            return;
        }
        try {
            this.appID = Apps.toAppID((String)aid);
        }
        catch (Exception e) {
            this.puts(new Object[]{"Invalid Application ID: " + aid});
            return;
        }
        UserGroupInformation callerUGI = this.getCallerUGI();
        try {
            final GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)this.appID);
            appReport = callerUGI == null ? this.appBaseProt.getApplicationReport(request).getApplicationReport() : (ApplicationReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationReport>(){

                @Override
                public ApplicationReport run() throws Exception {
                    return AppBlock.this.appBaseProt.getApplicationReport(request).getApplicationReport();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the application " + this.appID + ".";
            LOG.error((Object)message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        if (appReport == null) {
            this.puts(new Object[]{"Application not found: " + aid});
            return;
        }
        AppInfo app = new AppInfo(appReport);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application ", aid}));
        if (webUiType != null && webUiType.equals("ResourceManager") && this.conf.getBoolean("yarn.resourcemanager.webapp.ui-actions.enabled", true)) {
            ((Hamlet.DIV)html.div().button().$onclick("confirmAction()").b("Kill Application")._())._();
            StringBuilder script = new StringBuilder();
            script.append("function confirmAction() {").append(" b = confirm(\"Are you sure?\");").append(" if (b == true) {").append(" $.ajax({").append(" type: 'PUT',").append(" url: '/ws/v1/cluster/apps/").append(aid).append("/state',").append(" contentType: 'application/json',").append(AppBlock.getCSRFHeaderString(this.conf)).append(" data: '{\"state\":\"KILLED\"}',").append(" dataType: 'json'").append(" }).done(function(data){").append(" setTimeout(function(){").append(" location.href = '/cluster/app/").append(aid).append("';").append(" }, 1000);").append(" }).fail(function(data){").append(" console.log(data);").append(" });").append(" }").append("}");
            html.script().$type("text/javascript")._(new Object[]{script.toString()})._();
        }
        String schedulerPath = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.conf) + "/cluster/scheduler?openQueues=" + app.getQueue();
        ResponseInfo overviewTable = this.info("Application Overview")._("User:", schedulerPath, (Object)app.getUser())._("Name:", (Object)app.getName())._("Application Type:", (Object)app.getType())._("Application Tags:", (Object)(app.getApplicationTags() == null ? "" : app.getApplicationTags()))._("Application Priority:", (Object)this.clarifyAppPriority(app.getPriority()))._("YarnApplicationState:", (Object)(app.getAppState() == null ? "N/A" : this.clarifyAppState(app.getAppState())))._("Queue:", schedulerPath, (Object)app.getQueue())._("FinalStatus Reported by AM:", (Object)this.clairfyAppFinalStatus(app.getFinalAppStatus()))._("Started:", (Object)Times.format((long)app.getStartedTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)app.getStartedTime(), (long)app.getFinishedTime())))._("Tracking URL:", app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? null : this.root_url(new String[]{app.getTrackingUrl()}), (Object)(app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? "Unassigned" : (app.getAppState() == YarnApplicationState.FINISHED || app.getAppState() == YarnApplicationState.FAILED || app.getAppState() == YarnApplicationState.KILLED ? "History" : "ApplicationMaster")));
        if (webUiType != null && webUiType.equals("ResourceManager")) {
            LogAggregationStatus status = this.getLogAggregationStatus();
            if (status == null) {
                overviewTable._("Log Aggregation Status", (Object)"N/A");
            } else if (status == LogAggregationStatus.DISABLED || status == LogAggregationStatus.NOT_START || status == LogAggregationStatus.SUCCEEDED) {
                overviewTable._("Log Aggregation Status", (Object)status.name());
            } else {
                overviewTable._("Log Aggregation Status", this.root_url(new String[]{"logaggregationstatus", app.getAppId()}), (Object)status.name());
            }
        }
        overviewTable._("Diagnostics:", (Object)(app.getDiagnosticsInfo() == null ? "" : app.getDiagnosticsInfo()));
        overviewTable._("Unmanaged Application:", (Object)app.isUnmanagedApp());
        overviewTable._("Application Node Label expression:", (Object)(app.getAppNodeLabelExpression() == null ? "<Not set>" : app.getAppNodeLabelExpression()));
        overviewTable._("AM container Node Label expression:", (Object)(app.getAmNodeLabelExpression() == null ? "<Not set>" : app.getAmNodeLabelExpression()));
        try {
            final GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)this.appID);
            attempts = callerUGI == null ? this.appBaseProt.getApplicationAttempts(request).getApplicationAttemptList() : (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationAttemptReport>>(){

                @Override
                public Collection<ApplicationAttemptReport> run() throws Exception {
                    return AppBlock.this.appBaseProt.getApplicationAttempts(request).getApplicationAttemptList();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the attempts of the application " + this.appID + ".";
            LOG.error((Object)message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        this.createApplicationMetricsTable(html);
        html._(InfoBlock.class);
        this.generateApplicationTable(html, callerUGI, attempts);
    }

    protected void generateApplicationTable(HtmlBlock.Block html, UserGroupInformation callerUGI, Collection<ApplicationAttemptReport> attempts) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt ID").th(".started", "Started").th(".node", "Node").th(".logs", "Logs")._())._()).tbody();
        StringBuilder attemptsTableData = new StringBuilder("[\n");
        for (ApplicationAttemptReport appAttemptReport : attempts) {
            ContainerReport containerReport;
            AppAttemptInfo appAttempt = new AppAttemptInfo(appAttemptReport);
            try {
                final GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)appAttemptReport.getAMContainerId());
                containerReport = callerUGI == null ? this.appBaseProt.getContainerReport(request).getContainerReport() : (ContainerReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                    @Override
                    public ContainerReport run() throws Exception {
                        ContainerReport report = null;
                        if (request.getContainerId() != null) {
                            try {
                                report = AppBlock.this.appBaseProt.getContainerReport(request).getContainerReport();
                            }
                            catch (ContainerNotFoundException ex) {
                                LOG.warn((Object)ex.getMessage());
                            }
                        }
                        return report;
                    }
                });
            }
            catch (Exception e) {
                String message = "Failed to read the AM container of the application attempt " + appAttemptReport.getApplicationAttemptId() + ".";
                LOG.error((Object)message, (Throwable)e);
                html.p()._(new Object[]{message})._();
                return;
            }
            long startTime = 0L;
            String logsLink = null;
            String nodeLink = null;
            if (containerReport != null) {
                ContainerInfo container = new ContainerInfo(containerReport);
                startTime = container.getStartedTime();
                logsLink = containerReport.getLogUrl();
                nodeLink = containerReport.getNodeHttpAddress();
            }
            attemptsTableData.append("[\"<a href='").append(this.url(new String[]{"appattempt", appAttempt.getAppAttemptId()})).append("'>").append(appAttempt.getAppAttemptId()).append("</a>\",\"").append(startTime).append("\",\"<a ").append(nodeLink == null ? "#" : "href='" + nodeLink).append("'>").append(nodeLink == null ? "N/A" : StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)nodeLink))).append("</a>\",\"<a ").append(logsLink == null ? "#" : "href='" + logsLink).append("'>").append(logsLink == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
            attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
        }
        attemptsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var attemptsTableData=" + attemptsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }

    private String clarifyAppState(YarnApplicationState state) {
        String ret = state.toString();
        switch (state) {
            case NEW: {
                return ret + ": waiting for application to be initialized";
            }
            case NEW_SAVING: {
                return ret + ": waiting for application to be persisted in state-store.";
            }
            case SUBMITTED: {
                return ret + ": waiting for application to be accepted by scheduler.";
            }
            case ACCEPTED: {
                return ret + ": waiting for AM container to be allocated, launched and" + " register with RM.";
            }
            case RUNNING: {
                return ret + ": AM has registered with RM and started running.";
            }
        }
        return ret;
    }

    private String clarifyAppPriority(int priority) {
        return priority + " (Higher Integer value indicates higher priority)";
    }

    private String clairfyAppFinalStatus(FinalApplicationStatus status) {
        if (status == FinalApplicationStatus.UNDEFINED) {
            return "Application has not completed yet.";
        }
        return status.toString();
    }

    protected void createApplicationMetricsTable(HtmlBlock.Block html) {
    }

    protected LogAggregationStatus getLogAggregationStatus() {
        return null;
    }

    public static String getCSRFHeaderString(Configuration conf) {
        String ret = "";
        if (conf.getBoolean("yarn.resourcemanager.webapp.rest-csrf.enabled", false)) {
            ret = " headers : { '";
            Map filterParams = RestCsrfPreventionFilter.getFilterParams((Configuration)conf, (String)"yarn.resourcemanager.webapp.rest-csrf.");
            ret = filterParams.containsKey("custom-header") ? ret + (String)filterParams.get("custom-header") : ret + "X-XSRF-HEADER";
            ret = ret + "' : 'null' },";
        }
        return ret;
    }
}

