/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.dom.dom4j;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Attribute;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.dom.Namespace;
import org.pentaho.ui.xul.dom.dom4j.XulElementDom4J;

public class ElementDom4J
implements Element {
    protected org.dom4j.Element element;
    private static final Log logger = LogFactory.getLog(ElementDom4J.class);

    public ElementDom4J() {
    }

    public ElementDom4J(String name, XulComponent xulElement) {
        this.element = new XulElementDom4J(name.toLowerCase(), xulElement);
    }

    public ElementDom4J(String name) {
        this.element = new XulElementDom4J(name.toLowerCase());
    }

    @Override
    public List<XulComponent> getChildNodes() {
        ArrayList<XulComponent> list = new ArrayList<XulComponent>();
        List elements = this.element.elements();
        for (Object ele : elements) {
            list.add(((XulElementDom4J)((Object)ele)).getXulElement());
        }
        return list;
    }

    @Override
    public Document getDocument() {
        try {
            org.dom4j.Document doc = this.element.getDocument();
            if (doc == null) {
                return null;
            }
            XulElementDom4J o = (XulElementDom4J)doc.getRootElement();
            return ((XulRoot)o.getXulElement()).getXulDomContainer().getDocumentRoot();
        }
        catch (Exception e) {
            logger.warn((Object)("Could not get document node : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public XulComponent getElementById(String id) {
        XulElementDom4J ele = (XulElementDom4J)this.element.getDocument().elementByID(id);
        if (ele == null) {
            return null;
        }
        return ele.getXulElement();
    }

    @Override
    public XulComponent getElementByXPath(String path) {
        Node ele = this.element.selectSingleNode(path);
        if (ele != null) {
            return ((XulElementDom4J)ele).getXulElement();
        }
        return null;
    }

    @Override
    public List<XulComponent> getElementsByTagName(String tagName) {
        ArrayList<XulComponent> list = new ArrayList<XulComponent>();
        List elements = this.element.elements(tagName);
        for (Object ele : elements) {
            list.add(((XulElementDom4J)((Object)ele)).getXulElement());
        }
        return list;
    }

    @Override
    public XulComponent getFirstChild() {
        return ((XulElementDom4J)((Object)this.element.elements().get(0))).getXulElement();
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public Namespace getNamespace() {
        return new Namespace(this.element.getNamespace().getURI(), this.element.getNamespace().getPrefix());
    }

    @Override
    public XulComponent getParent() {
        if (this.element.getParent() == null) {
            return null;
        }
        return ((XulElementDom4J)this.element.getParent()).getXulElement();
    }

    @Override
    public String getText() {
        return this.element.getText();
    }

    @Override
    public void setNamespace(String prefix, String uri) {
        this.element.addNamespace(prefix, uri);
    }

    @Override
    public void setAttribute(Attribute attribute) {
        this.setAttribute(attribute.getName(), attribute.getValue());
    }

    @Override
    public void addChild(Element ele) {
        org.dom4j.Element dElement = (org.dom4j.Element)ele.getElementObject();
        org.dom4j.Element dElementparent = dElement.getParent();
        if (dElementparent != null) {
            dElementparent.remove(dElement);
        }
        this.element.add(dElement);
    }

    @Override
    public void addChildAt(Element element, int idx) {
        org.dom4j.Element dElement = (org.dom4j.Element)element.getElementObject();
        org.dom4j.Element dElementparent = dElement.getParent();
        if (dElementparent != null) {
            dElementparent.remove(dElement);
        }
        this.element.elements().add(idx, dElement);
    }

    @Override
    public Object getElementObject() {
        return this.element;
    }

    @Override
    public List<Attribute> getAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        List elements = this.element.attributes();
        for (Object ele : elements) {
            org.dom4j.Attribute baseAttrib = (org.dom4j.Attribute)ele;
            list.add(new Attribute(baseAttrib.getName(), baseAttrib.getValue()));
        }
        return list;
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.element.attributeValue(attributeName);
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        for (Attribute attrib : attributes) {
            this.setAttribute(attrib.getName(), attrib.getValue());
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if (name.equals("id") || name.equals("ID")) {
            this.element.addAttribute("ID", value);
        } else {
            this.element.addAttribute(name, value);
        }
    }

    @Override
    public void removeChild(Element ele) {
        this.element.remove((org.dom4j.Element)ele.getElementObject());
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) {
        List contentOfParent = this.element.content();
        int index = contentOfParent.indexOf((org.dom4j.Element)oldElement.getElementObject());
        contentOfParent.set(index, (org.dom4j.Element)newElement.getElementObject());
    }

    public void setComponent(XulComponent c) {
        ((XulElementDom4J)this.element).setXulElement(c);
    }
}

