/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulContainer;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.DocumentFactory;
import org.pentaho.ui.xul.impl.AbstractXulComponent;
import org.pentaho.ui.xul.util.XulUtil;

public class XulParser {
    Document xulDocument;
    private static final Log logger = LogFactory.getLog(XulParser.class);
    public Map<String, Object> handlers = new HashMap<String, Object>();
    private Map<String, Constructor<?>> constructorCache = new HashMap();
    private XulDomContainer xulDomContainer;
    private List<ClassLoader> classloaders = new ArrayList<ClassLoader>();

    public XulParser() throws XulException {
        this.classloaders.add(this.getClass().getClassLoader());
        try {
            this.xulDocument = DocumentFactory.createDocument();
        }
        catch (Exception e) {
            throw new XulException("Error getting Document instance", e);
        }
    }

    public void setContainer(XulDomContainer xulDomContainer) {
        this.xulDomContainer = xulDomContainer;
        this.xulDocument.setXulDomContainer(xulDomContainer);
        xulDomContainer.addDocument(this.xulDocument);
    }

    public Document parseDocument(Element rootSrc) throws XulException {
        XulComponent root;
        XulContainer parent = null;
        if (!rootSrc.getName().equalsIgnoreCase("window") && !rootSrc.getName().equalsIgnoreCase("dialog")) {
            parent = this.getPlaceHolderRoot();
        }
        if ((root = this.parse(rootSrc, parent)) instanceof XulRoot) {
            ((XulRoot)root).setXulDomContainer(this.xulDomContainer);
            this.xulDocument.addChild(root);
        } else {
            ((XulRoot)parent).setXulDomContainer(this.xulDomContainer);
            parent.addChild(root);
            this.xulDocument.addChild(parent);
        }
        if (rootSrc.getName().equalsIgnoreCase("window") || rootSrc.getName().equalsIgnoreCase("dialog")) {
            this.notifyDomReady(root);
        }
        return this.xulDocument;
    }

    private void notifyDomReady(XulComponent node) {
        node.onDomReady();
        for (XulComponent c : node.getChildNodes()) {
            this.notifyDomReady(c);
        }
    }

    private Constructor<?> getContructor(String className) throws XulException {
        Constructor<?> con = this.constructorCache.get(className);
        if (con != null) {
            return con;
        }
        Class<?> c = null;
        ClassNotFoundException lastException = null;
        for (ClassLoader loader : this.classloaders) {
            try {
                c = loader.loadClass(className);
                if (c == null) continue;
                break;
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        if (c == null && lastException != null) {
            throw new XulException(lastException);
        }
        try {
            Constructor<?> constructor = c.getConstructor(org.pentaho.ui.xul.dom.Element.class, XulComponent.class, XulDomContainer.class, String.class);
            this.constructorCache.put(className, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e1) {
            throw new XulException(e1);
        }
    }

    public XulContainer getPlaceHolderRoot() throws XulException {
        try {
            Object handlerClassName = this.handlers.get("WINDOW");
            if (handlerClassName == null) {
                throw new XulException("Could not find a tag handler for window");
            }
            XulWindow ele = (XulWindow)this.getContructor(handlerClassName.toString()).newInstance(null, null, this.xulDomContainer, "window");
            return ele;
        }
        catch (Exception e) {
            throw new XulException(e);
        }
    }

    public XulComponent parse(Element rootSrc, XulContainer parent) throws XulException {
        XulComponent root = this.getElement(rootSrc, parent);
        if (root == null) {
            return null;
        }
        for (Object child : rootSrc.elements()) {
            XulComponent childElement = this.parse((Element)child, (XulContainer)root);
            if (childElement == null) continue;
            root.addChild(childElement);
        }
        if (root != null && root instanceof AbstractXulComponent) {
            ((AbstractXulComponent)root).layout();
        }
        return root;
    }

    protected XulComponent getElement(Element srcEle, XulContainer parent) throws XulException {
        Object handler;
        String potentialHandlerName;
        String handlerName = srcEle.getName().toUpperCase();
        Attribute att = srcEle.attribute(new QName("customclass", new Namespace("pen", "http://www.pentaho.org/2008/xul")));
        if (att != null && this.handlers.get(potentialHandlerName = att.getValue().toUpperCase()) != null) {
            handlerName = potentialHandlerName;
        }
        if ((handler = this.handlers.get(handlerName)) == null) {
            logger.error((Object)("handler not found: " + handlerName));
            return null;
        }
        String tagName = srcEle.getName();
        try {
            Constructor<?> constructor = this.getContructor((String)handler);
            org.pentaho.ui.xul.dom.Element domEle = DocumentFactory.createElement(srcEle.getName().toLowerCase());
            List attrs = srcEle.attributes();
            for (Object attr : attrs) {
                domEle.setAttribute(attr.getName(), attr.getValue());
            }
            XulComponent ele = (XulComponent)constructor.newInstance(domEle, parent, this.xulDomContainer, tagName);
            for (Attribute attr : attrs) {
                ele.setAttribute(attr.getName(), attr.getValue());
            }
            Map<String, String> attributesMap = XulUtil.AttributesToMap(srcEle.attributes());
            BeanUtils.populate((Object)ele, attributesMap);
            return ele;
        }
        catch (Exception e) {
            throw new XulException(e);
        }
    }

    public XulComponent getElement(String name) throws XulException {
        return this.getElement(name, null);
    }

    public XulComponent getElement(String name, XulComponent defaultParent) throws XulException {
        Object handler = this.handlers.get(name.toUpperCase());
        if (handler == null) {
            logger.error((Object)("tag handler not found: " + name));
            throw new XulException(String.format("No handler available for input: %s", name));
        }
        try {
            Constructor<?> constructor = this.getContructor((String)handler);
            XulComponent ele = (XulComponent)constructor.newInstance(null, defaultParent, this.xulDomContainer, name);
            return ele;
        }
        catch (Exception e) {
            throw new XulException(e);
        }
    }

    public void registerHandler(String type, String handler) {
        this.handlers.put(type.toUpperCase(), handler);
    }

    public Document getDocumentRoot() {
        return this.xulDocument;
    }

    public void reset() throws XulException {
        try {
            this.xulDocument = DocumentFactory.createDocument();
        }
        catch (Exception e) {
            throw new XulException("Error getting Document instance", e);
        }
    }

    public void setClassLoaders(List<ClassLoader> loaders) {
        this.classloaders = loaders;
    }
}

