/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.samples;

import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.samples.FormModel;
import org.pentaho.ui.xul.samples.Product;
import org.pentaho.ui.xul.samples.ProductModel;

public class BindingEventHandler
extends AbstractXulEventHandler {
    public FormModel model;
    public ProductModel productModel;
    public DefaultBinding removeMeBinding;

    public void test() {
        this.model.setFirstName("Oliver");
        this.model.setLastName("Twist");
    }

    public void test2() {
        ((XulTextbox)this.document.getElementById("firstNameInput")).setValue("James");
        ((XulTextbox)this.document.getElementById("lastNameInput")).setValue("Kirk");
    }

    public void toggleBoolean() {
        this.model.setDisabled(!this.model.isDisabled());
    }

    public void addProduct() {
        String name = ((XulTextbox)this.document.getElementById("productName")).getValue();
        String descr = ((XulTextbox)this.document.getElementById("productDescr")).getValue();
        this.productModel.addProduct(new Product(name, descr));
    }

    public void removeBinding() {
        this.getXulDomContainer().removeBinding(this.removeMeBinding);
    }

    public void onLoad() {
        this.model = new FormModel();
        this.productModel = new ProductModel();
        XulLabel firstNameLbl = (XulLabel)this.document.getElementById("firstName");
        XulLabel lastNameLbl = (XulLabel)this.document.getElementById("lastName");
        DefaultBinding binding = new DefaultBinding(this.model, "firstName", firstNameLbl, "value");
        this.getXulDomContainer().addBinding(binding);
        this.removeMeBinding = binding;
        binding = new DefaultBinding(this.model, "lastName", lastNameLbl, "value");
        this.getXulDomContainer().addBinding(binding);
        binding = new DefaultBinding(this.document, this.model, "firstName", "firstNameInput", "value");
        this.getXulDomContainer().addBinding(binding);
        this.getXulDomContainer().createBinding(this.model, "lastName", "lastNameInput", "value");
        this.getXulDomContainer().createBinding("echoTextbox", "value", "echoLabel", "value");
        this.getXulDomContainer().createBinding(this.model, "disabled", "disabledButton", "disabled");
        this.getXulDomContainer().createBinding("checkbox", "!checked", "inversedDisabledButton", "disabled");
        this.getXulDomContainer().createBinding(this.productModel, "products", "productTable", "elements");
        binding = new DefaultBinding(this.document, "degreesField", "value", "radiansField", "value");
        binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
        binding.setConversion(new BindingConvertor<String, String>(){

            @Override
            public String sourceToTarget(String value) {
                float degrees = Float.parseFloat(value);
                return String.format("%.2f", (double)degrees * (Math.PI / 180));
            }

            @Override
            public String targetToSource(String value) {
                float radians = Float.parseFloat(value);
                return String.format("%.2f", (double)radians * 57.29577951308232);
            }
        });
        this.getXulDomContainer().addBinding(binding);
        Binding bind = this.getXulDomContainer().createBinding("nthItem", "value", "itemsList", "selectedIndex");
        bind.setConversion(new BindingConvertor<String, Integer>(){

            @Override
            public Integer sourceToTarget(String value) {
                return Integer.parseInt(value);
            }

            @Override
            public String targetToSource(Integer value) {
                return value.toString();
            }
        });
    }
}

