/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Attribute;
import org.pentaho.ui.xul.XulDomContainer;

public final class XulUtil {
    public static Map<String, String> AttributesToMap(List<Attribute> attMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attMap.size(); ++i) {
            Attribute node = attMap.get(i);
            String name = node.getName();
            if (name.equals("ID")) {
                name = "id";
            }
            map.put(name, node.getValue());
        }
        return map;
    }

    public static List<org.pentaho.ui.xul.dom.Attribute> convertAttributes(List<Attribute> inList) {
        ArrayList<org.pentaho.ui.xul.dom.Attribute> outList = new ArrayList<org.pentaho.ui.xul.dom.Attribute>();
        for (Attribute attr : inList) {
            outList.add(new org.pentaho.ui.xul.dom.Attribute(attr.getName(), attr.getValue()));
        }
        return outList;
    }

    public static InputStream getResourceFromClassPath(String file) {
        InputStream in = XulUtil.class.getClassLoader().getResourceAsStream(XulUtil.formatResourceName(file));
        if (in == null) {
            in = XulUtil.class.getClassLoader().getResourceAsStream(String.format(file, new Object[0]));
        }
        return in;
    }

    public static String formatResourceName(String name) {
        return name.replace(".xul", "-" + Locale.getDefault().toString() + ".xul");
    }

    public static InputStream loadResourceAsStream(String src, XulDomContainer domContainer) throws FileNotFoundException {
        if (src == null || src.equals("")) {
            return null;
        }
        InputStream in = (InputStream)domContainer.getXulLoader().getResourceAsStream(domContainer.getXulLoader().getRootDir() + src);
        if (in == null) {
            File f = new File(src);
            if (!f.exists()) {
                f = new File(domContainer.getXulLoader().getRootDir() + src);
            }
            if (f.exists()) {
                in = new FileInputStream(f);
                return in;
            }
        }
        if (in == null) {
            in = (InputStream)domContainer.getXulLoader().getResourceAsStream(src);
        }
        if (in == null) {
            throw new FileNotFoundException("Could not locate resource: " + src);
        }
        return in;
    }
}

