/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import org.apache.oozie.util.XLog;

public enum ErrorCode {
    E0000(1, "System property ''oozie.home.dir'' not defined"),
    E0001(4, "Could not create runtime directory, {0}"),
    E0002(1, "System is in safe mode"),
    E0003(4, "Oozie home directory must be an absolute path [{0}]"),
    E0004(4, "Oozie home directory does not exist [{0}]"),
    E0010(4, "Could not initialize log service, {0}"),
    E0011(4, "Log4j file must be a file name [{0}]"),
    E0012(4, "Log4j file must be a ''.properties'' file [{0}]"),
    E0013(4, "Log4j file [{0}] not found in configuration dir [{1}] neither in classpath"),
    E0020(4, "Environment variable {0} not defined"),
    E0022(4, "Configuration file must be a file name [{0}]"),
    E0023(4, "Default configuration file [{0}] not found in classpath"),
    E0024(4, "Oozie configuration directory does not exist [{0}]"),
    E0025(4, "Configuration service internal error, it should never happen, {0}"),
    E0026(4, "Missing required configuration property [{0}]"),
    E0100(4, "Could not initialize service [{0}], {1}"),
    E0101(4, "Service [{0}] does not implement declared interface [{1}]"),
    E0102(4, "Could not instantiate service class [{0}], {1}"),
    E0103(4, "Could not load service classes, {0}"),
    E0104(4, "Could not fully initialize service [{0}], {1}"),
    E0110(4, "Could not parse or validate EL definition [{0}], {1}"),
    E0111(4, "class#method not found [{0}#{1}]"),
    E0112(4, "class#method does not have PUBLIC or STATIC modifier [{0}#{1}]"),
    E0113(4, "class not found [{0}]"),
    E0114(4, "class#constant does not have PUBLIC or STATIC modifier [{0}#{1}]"),
    E0115(4, "class#constant not found"),
    E0116(4, "class#constant does not have PUBLIC or STATIC modifier [{0}#{1}]"),
    E0120(4, "UUID, invalid generator type [{0}]"),
    E0130(4, "Could not parse workflow schemas file/s, {0}"),
    E0131(4, "Could not read workflow schemas file/s, {0}"),
    E0140(4, "Could not access database, {0}"),
    E0141(4, "Could not create DataSource connection pool, {0}"),
    E0160(4, "Could not read admin users file [{0}], {1}"),
    E0300(1, "Invalid content-type [{0}]"),
    E0301(1, "Invalid resource [{0}]"),
    E0302(1, "Invalid parameter [{0}]"),
    E0303(1, "Invalid parameter value, [{0}] = [{1}]"),
    E0304(1, "Invalid parameter type, parameter [{0}] expected type [{1}]"),
    E0305(1, "Missing parameter [{0}]"),
    E0306(1, "Invalid parameter"),
    E0307(1, "Runtime error [{0}]"),
    E0308(1, "Could not parse date range parameter [{0}]"),
    E0401(1, "Missing configuration property [{0}]"),
    E0402(1, "Invalid callback ID [{0}]"),
    E0403(1, "Invalid callback data, {0}"),
    E0404(1, "Only one of the properties are allowed [{0}]"),
    E0405(1, "Submission request doesn''t have any application or lib path"),
    E0420(1, "Invalid jobs filter [{0}], {1}"),
    E0421(1, "Invalid job filter [{0}], {1}"),
    E0500(4, "Not authorized, {0}"),
    E0501(4, "Could not perform authorization operation, {0}"),
    E0502(4, "User [{0}] does not belong to group [{1}]"),
    E0503(4, "User [{0}] does not have admin privileges"),
    E0504(4, "App directory [{0}] does not exist"),
    E0505(4, "App definition [{0}] does not exist"),
    E0506(4, "App definition [{0}] is not a file"),
    E0507(4, "Could not access to [{0}], {1}"),
    E0508(4, "User [{0}] not authorized for WF job [{1}]"),
    E0509(4, "User [{0}] not authorized for Coord job [{1}]"),
    E0510(4, "Unable to get Credential [{0}]"),
    E0550(4, "Could not normalize host name [{0}], {1}"),
    E0551(4, "Missing [{0}] property"),
    E0600(4, "Could not get connection, {0}"),
    E0601(4, "Could not close connection, {0}"),
    E0602(4, "Could not commit connection, {0}"),
    E0603(4, "SQL error in operation, {0}"),
    E0604(1, "Job does not exist [{0}]"),
    E0605(1, "Action does not exist [{0}]"),
    E0606(1, "Could not get lock [{0}], timed out [{1}]ms"),
    E0607(4, "Other error in operation [{0}], {1}"),
    E0608(4, "JDBC setup error [{0}], {1}"),
    E0609(4, "Missing [{0}] ORM file [{1}]"),
    E0610(4, "Missing JPAService, StoreService cannot run without a JPAService"),
    E0611(4, "SQL error in operation [{0}], {1}"),
    E0700(1, "XML error, {0}"),
    E0701(1, "XML schema error, {0}"),
    E0702(1, "IO error, {0}"),
    E0703(1, "Invalid workflow element [{0}]"),
    E0704(1, "Definition already complete, application [{0}]"),
    E0705(1, "Nnode already defined, node [{0}]"),
    E0706(1, "Node cannot transition to itself node [{0}]"),
    E0707(1, "Loop detected at parsing, node [{0}]"),
    E0708(1, "Invalid transition, node [{0}] transition [{1}]"),
    E0709(1, "Loop detected at runtime, node [{0}]"),
    E0710(1, "Could not read the workflow definition, {0}"),
    E0711(1, "Invalid application URI [{0}], {1}"),
    E0712(1, "Could not create lib paths list for application [{0}], {1}"),
    E0713(4, "SQL error, {0}"),
    E0714(4, "Workflow lib error, {0}"),
    E0715(4, "Invalid signal value for the start node, signal [{0}]"),
    E0716(4, "Workflow not running"),
    E0717(4, "Workflow not suspended"),
    E0718(4, "Workflow already completed"),
    E0719(4, "Job already started"),
    E0720(4, "Fork/join mismatch, node [{0}]"),
    E0721(4, "Invalid signal/transition, decision node [{0}] signal [{1}]"),
    E0722(4, "Action signals can only be OK or ERROR, action node [{0}]"),
    E0723(1, "Unsupported action type, node [{0}] type [{1}]"),
    E0724(1, "Invalid node name, {0}"),
    E0725(1, "Workflow instance can not be killed, {0}"),
    E0726(1, "Workflow action can not be killed, {0}"),
    E0727(1, "Workflow Job can not be suspended as its not in running state, {0}, Status: {1}"),
    E0728(1, "Coordinator Job can not be suspended as job finished or failed or killed, id : {0}, status : {1}"),
    E0729(4, "Kill node message [{0}]"),
    E0730(1, "Fork/Join not in pair"),
    E0731(1, "Fork node [{0}] cannot have less than two paths"),
    E0732(1, "Fork [{0}]/Join [{1}] not in pair (join should have been [{2}])"),
    E0733(1, "Fork [{0}] without a join"),
    E0734(1, "Invalid transition from node [{0}] to node [{1}] while using fork/join"),
    E0735(1, "There was an invalid \"error to\" transition to node [{1}] while using fork/join"),
    E0736(1, "Workflow definition length [{0}] exceeded maximum allowed length [{1}]"),
    E0737(1, "Invalid transition from node [{0}] to node [{1}] -- nodes of type ''end'' are not allowed within Fork/Join"),
    E0738(1, "The following {0} parameters are required but were not defined and no default values are available: {1}"),
    E0739(1, "Parameter name cannot be empty"),
    E0740(1, "Invalid node type encountered (node [{0}])"),
    E0741(1, "Cycle detected transitioning to [{0}] via path {1}"),
    E0742(1, "No Fork for Join [{0}] to pair with"),
    E0743(1, "Multiple \"ok to\" transitions to the same node, [{0}], are not allowed"),
    E0744(1, "A fork, [{0}], is not allowed to have multiple transitions to the same node, [{1}]"),
    E0755(1, "Workflow Job Rerun Error: {0}"),
    E0800(1, "Action it is not running its in [{1}] state, action [{0}]"),
    E0801(1, "Workflow already running, workflow [{0}]"),
    E0802(1, "Invalid action type [{0}]"),
    E0803(1, "IO error, {0}"),
    E0804(1, "Disallowed default property [{0}]"),
    E0805(1, "Workflow job not completed, status [{0}]"),
    E0806(1, "Action did not complete in previous run, action [{0}]"),
    E0807(1, "Some skip actions were not executed [{0}]"),
    E0808(1, "Disallowed user property [{0}]"),
    E0809(1, "Workflow action is not eligible to start [{0}]"),
    E0810(1, "Job state is not [{0}]. Skipping ActionStart Execution"),
    E0811(1, "Job state is not [{0}]. Skipping ActionEnd Execution"),
    E0812(1, "Action pending=[{0}], status=[{1}]. Skipping ActionEnd Execution"),
    E0813(1, "Workflow not RUNNING, current status [{0}]"),
    E0814(1, "SignalCommand for action id=[{0}] is already processed, status=[{1}], , pending=[{2}]"),
    E0815(1, "Action pending=[{0}], status=[{1}]. Skipping ActionCheck Execution"),
    E0816(1, "Action pending=[{0}], status=[{1}]. Skipping ActionStart Execution"),
    E0817(1, "The wf action [{0}] has been udated recently. Ignoring ActionCheck."),
    E0818(1, "Action [{0}] status is running but WF Job [{1}] status is [{2}]. Expected status is RUNNING or SUSPENDED."),
    E0819(1, "Unable to delete the temp dir of job WF Job [{0}]."),
    E0820(1, "Action user retry max [{0}] is over system defined max [{1}], re-assign to use system max."),
    E0821(1, "Received early callback for action still in PREP state; will wait [{0}]ms and requeue up to [{1}] more times"),
    E0822(1, "Received early callback for action [{0}] while still in PREP state and exhausted all requeues"),
    E0900(4, "JobTracker [{0}] not allowed, not in Oozie''s whitelist. Allowed values are: {1}"),
    E0901(4, "NameNode [{0}] not allowed, not in Oozie''s whitelist. Allowed values are: {1}"),
    E0902(4, "Exception occured: [{0}]"),
    E0903(4, "Invalid JobConf, it has not been created by HadoopAccessorService"),
    E0904(1, "Scheme [{0}] not supported in uri [{1}]"),
    E0905(1, "Scheme not present in uri [{0}]"),
    E0906(1, "URI parsing error : {0}"),
    E0907(1, "Failed to delete uri : {0}"),
    E1001(1, "Could not read the coordinator job definition, {0}"),
    E1002(1, "Invalid coordinator application URI [{0}], {1}"),
    E1003(1, "Invalid coordinator application attributes, {0}"),
    E1004(1, "Expression language evaluation error, {0}"),
    E1005(1, "Could not read the coordinator job configuration read from DB, {0}"),
    E1006(1, "Invalid coordinator application [{0}], {1}"),
    E1007(1, "Unable to add record for SLA. [{0}], {1}"),
    E1008(1, "Not implemented. [{0}]"),
    E1009(1, "Unable to parse XML response. [{0}]"),
    E1010(1, "Invalid data in coordinator xml. [{0}]"),
    E1011(1, "Cannot update coordinator job [{0}], {1}"),
    E1012(1, "Coord Job Materialization Error: {0}"),
    E1013(1, "Coord Job Recovery Error: {0}"),
    E1014(1, "Coord job change command not supported"),
    E1015(1, "Invalid coordinator job change value {0}, {1}"),
    E1016(1, "Cannot change a killed coordinator job"),
    E1017(1, "Cannot change a workflow job"),
    E1018(1, "Coord Job Rerun Error: {0}"),
    E1019(1, "Could not submit coord job, [{0}]"),
    E1020(1, "Could not kill coord job, this job either finished successfully or does not exist , [{0}]"),
    E1021(1, "Coord Action Input Check Error: {0}"),
    E1022(1, "Cannot delete running/completed coordinator action: [{0}]"),
    E1023(1, "Coord Job update Error: [{0}]"),
    E1024(1, "Cannot run ignore command: [{0}]"),
    E1025(1, "Coord status transit error: [{0}]"),
    E1026(1, "SLA alert update command failed: {0}"),
    E1027(1, "SLA change command failed. {0}"),
    E1100(1, "Command precondition does not hold before execution, [{0}]"),
    E1101(1, "SLA <{0}> cannot be empty."),
    E1102(1, "Invalid operation [{0}] for bulk command"),
    E1201(1, "State [{0}] is invalid for job [{1}]."),
    E1301(1, "Could not read the bundle job definition, [{0}]"),
    E1302(1, "Invalid bundle application URI [{0}], {1}"),
    E1303(1, "Invalid bundle application attributes [{0}], {1}"),
    E1304(1, "Duplicate bundle application coordinator name [{0}]"),
    E1305(1, "Empty bundle application coordinator name."),
    E1306(1, "Could not read the bundle job configuration, [{0}]"),
    E1307(1, "Could not read the bundle coord job configuration, [{0}]"),
    E1308(1, "Bundle Action Status  [{0}] is not matching with coordinator previous status [{1}]."),
    E1309(1, "Bundle Action for bundle ID  [{0}] and Coordinator [{1}] could not be update by BundleStatusUpdateXCommand"),
    E1310(1, "Bundle Job submission Error: [{0}]"),
    E1311(1, "Bundle Action for bundle ID  [{0}] not found"),
    E1312(1, "Bundle Job can not be suspended as job finished or failed or killed, id : {0}, status : {1}"),
    E1313(1, "Bundle Job can not be changed as job finished, {0}, Status: {1}"),
    E1314(1, "Bundle Job can not be changed as job does not exist, {0}"),
    E1315(1, "Bundle job can not be paused, {0}"),
    E1316(1, "Bundle job can not be unpaused, {0}"),
    E1317(1, "Invalid bundle job change value {0}, {1}"),
    E1318(1, "No coord jobs for the bundle=[{0}], fail the bundle"),
    E1319(1, "Invalid bundle coord job namespace, [{0}]"),
    E1320(1, "Bundle Job change error, [{0}]"),
    E1321(1, "Error evaluating coord name, [{0}]"),
    E1322(1, "Bundle status transit error: [{0}]"),
    E1323(1, "Could not kill bundle job, this job either finished successfully or does not exist , [{0}]"),
    E1400(1, "doAs (proxyuser) failure"),
    E1501(1, "Error in getting HCat Access [{0}]"),
    E1601(1, "Cannot retrieve JMS connection info [{0}]"),
    E1602(1, "Cannot retrieve Topic name [{0}]"),
    E1603(1, "Invalid user request"),
    E1700(1, "Issue communicating with ZooKeeper: {0}"),
    ETEST(1, "THIS SHOULD HAPPEN ONLY IN TESTING, invalid job id [{0}]");

    private String template;
    private int logMask;

    private ErrorCode(int logMask, String template) {
        this.logMask = logMask;
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public int getLogMask() {
        return this.logMask;
    }

    public String format(Object ... args) {
        return XLog.format("{0}: {1}", this.toString(), XLog.format(this.getTemplate(), args));
    }
}

