/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PauseTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.LogUtils;

public class BundlePauseXCommand
extends PauseTransitionXCommand {
    private BundleJobBean bundleJob;

    public BundlePauseXCommand(BundleJobBean bundleJob) {
        super("bundle_pause", "bundle_pause", 1);
        this.bundleJob = bundleJob;
    }

    @Override
    public String getEntityKey() {
        return this.bundleJob.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public void loadState() throws CommandException {
        LogUtils.setLogInfo(this.bundleJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    public void notifyParent() {
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }

    @Override
    public void updateJob() throws CommandException {
        try {
            BundleJobQueryExecutor.getInstance().executeUpdate(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS, this.bundleJob);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void pauseChildren() throws CommandException {
    }

    @Override
    public void performWrites() throws CommandException {
    }
}

