/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.RerunTransitionXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CoordRerunXCommand
extends RerunTransitionXCommand<CoordinatorActionInfo> {
    public static final String RERUN_CONF = "rerunConf";
    private String rerunType;
    private String scope;
    private boolean refresh;
    private boolean noCleanup;
    private CoordinatorJobBean coordJob = null;
    protected boolean prevPending;
    private boolean failed;
    private Configuration actionRunConf;

    public CoordRerunXCommand(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed, Configuration actionRunConf) {
        super("coord_rerun", "coord_rerun", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.rerunType = ParamChecker.notEmpty(rerunType, "rerunType");
        this.scope = ParamChecker.notEmpty(scope, "scope");
        this.refresh = refresh;
        this.noCleanup = noCleanup;
        this.failed = failed;
        this.actionRunConf = actionRunConf;
    }

    private static boolean checkAllActionsRunnable(List<CoordinatorActionBean> coordActions) {
        ParamChecker.notNull(coordActions, "Coord actions to be rerun");
        boolean ret = false;
        for (CoordinatorActionBean coordAction : coordActions) {
            ret = true;
            if (coordAction.isTerminalStatus()) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private void cleanupOutputEvents(Element eAction) throws CommandException {
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        if (outputList != null) {
            for (Element data : outputList.getChildren("data-out", eAction.getNamespace())) {
                String uris;
                String nocleanup = data.getAttributeValue("nocleanup");
                if (data.getChild("uris", data.getNamespace()) == null || nocleanup != null && nocleanup.equals("true") || (uris = data.getChild("uris", data.getNamespace()).getTextTrim()) == null) continue;
                String[] uriArr = uris.split("#");
                XConfiguration actionConf = null;
                try {
                    actionConf = new XConfiguration(new StringReader(this.coordJob.getConf()));
                }
                catch (IOException e) {
                    throw new CommandException(ErrorCode.E0907, "failed to read coord job conf to clean up output data");
                }
                HashMap<String, URIHandler.Context> contextMap = new HashMap<String, URIHandler.Context>();
                try {
                    for (String uriStr : uriArr) {
                        URI uri = new URI(uriStr);
                        URIHandler handler = Services.get().get(URIHandlerService.class).getURIHandler(uri);
                        String schemeWithAuthority = uri.getScheme() + "://" + uri.getAuthority();
                        if (!contextMap.containsKey(schemeWithAuthority)) {
                            URIHandler.Context context = handler.getContext(uri, actionConf, this.coordJob.getUser(), false);
                            contextMap.put(schemeWithAuthority, context);
                        }
                        handler.delete(uri, (URIHandler.Context)contextMap.get(schemeWithAuthority));
                        this.LOG.info("Cleanup the output data " + uri.toString());
                    }
                }
                catch (URISyntaxException e) {
                    throw new CommandException(ErrorCode.E0907, e.getMessage());
                }
                catch (URIHandlerException e) {
                    throw new CommandException(ErrorCode.E0907, e.getMessage());
                }
                finally {
                    Iterator itr = contextMap.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        ((URIHandler.Context)entry.getValue()).destroy();
                        itr.remove();
                    }
                }
            }
        } else {
            this.LOG.info("No output-events defined in coordinator xml. Therefore nothing to cleanup");
        }
    }

    private void refreshAction(CoordinatorJobBean coordJob, CoordinatorActionBean coordAction) throws Exception {
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration(new StringReader(coordJob.getConf()));
        }
        catch (IOException ioe) {
            this.LOG.warn((Object)("Configuration parse error. read from DB :" + coordJob.getConf()), ioe);
            throw new CommandException(ErrorCode.E1005, ioe.getMessage(), ioe);
        }
        String jobXml = coordJob.getJobXml();
        Element eJob = XmlUtils.parseXml(jobXml);
        Date actualTime = new Date();
        String actionXml = CoordCommandUtils.materializeOneInstance(this.jobId, this.dryrun, (Element)eJob.clone(), coordAction.getNominalTime(), actualTime, coordAction.getActionNumber(), jobConf, coordAction);
        this.LOG.debug("Refresh Action actionId=" + coordAction.getId() + ", actionXml=" + XmlUtils.prettyPrint(actionXml).toString());
        coordAction.setActionXml(actionXml);
    }

    private void updateAction(CoordinatorJobBean coordJob, CoordinatorActionBean coordAction) throws Exception {
        this.LOG.debug("updateAction for actionId=" + coordAction.getId());
        if (coordAction.getStatus() == CoordinatorAction.Status.TIMEDOUT) {
            this.LOG.debug("Updating created time for TIMEDOUT action id =" + coordAction.getId());
            coordAction.setCreatedTime(new Date());
        }
        coordAction.setStatus(CoordinatorAction.Status.WAITING);
        if (!this.failed) {
            coordAction.setExternalId(null);
        }
        coordAction.setExternalStatus(null);
        coordAction.setRerunTime(new Date());
        coordAction.setLastModifiedTime(new Date());
        coordAction.setErrorCode("");
        coordAction.setErrorMessage("");
        if (this.actionRunConf != null && this.actionRunConf.size() > 0) {
            Configuration createdConf = null;
            createdConf = coordAction.getCreatedConf() != null ? new XConfiguration(new StringReader(coordAction.getCreatedConf())) : new Configuration();
            createdConf.set(RERUN_CONF, XmlUtils.prettyPrint(this.actionRunConf).toString());
            coordAction.setCreatedConf(XmlUtils.prettyPrint(createdConf).toString());
        }
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_RERUN, coordAction));
        this.writeActionRegistration(coordAction.getActionXml(), coordAction, coordJob.getUser(), coordJob.getGroup());
    }

    private void writeActionRegistration(String actionXml, CoordinatorActionBean actionBean, String user, String group) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml);
        Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
        SLAEventBean slaEvent = SLADbOperations.createSlaRegistrationEvent(eSla, actionBean.getId(), SLAEvent.SlaAppType.COORDINATOR_ACTION, user, group, this.LOG);
        if (slaEvent != null) {
            this.insertList.add(slaEvent);
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, this.jobId);
            this.prevPending = this.coordJob.isPending();
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        LogUtils.setLogInfo(this.coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.coordJob.getStatus());
        if (this.coordJob.getStatus() == Job.Status.PREP || this.coordJob.getStatus() == Job.Status.IGNORED) {
            this.LOG.info("CoordRerunXCommand is not able to run, job status=" + this.coordJob.getStatus() + ", jobid=" + this.jobId);
            if (this.coordJob.getBundleId() != null) {
                bundleStatusUpdate.call();
            }
            if (this.coordJob.getStatus() == Job.Status.PREP) {
                throw new CommandException(ErrorCode.E1018, "coordinator job is PREP so no actions are materialized to rerun!");
            }
            throw new CommandException(ErrorCode.E1018, "coordinator job is IGNORED, please change it to RUNNING before rerunning actions");
        }
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, this.jobId);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        this.verifyPrecondition();
    }

    @Override
    public void rerunChildren() throws CommandException {
        boolean isError = false;
        try {
            CoordinatorActionInfo coordInfo = null;
            InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
            List<CoordinatorActionBean> coordActions = CoordUtils.getCoordActions(this.rerunType, this.jobId, this.scope, false);
            if (CoordRerunXCommand.checkAllActionsRunnable(coordActions)) {
                for (CoordinatorActionBean coordAction : coordActions) {
                    String actionXml = coordAction.getActionXml();
                    if (!this.noCleanup) {
                        Element eAction = XmlUtils.parseXml(actionXml);
                        this.cleanupOutputEvents(eAction);
                    }
                    if (this.refresh) {
                        this.refreshAction(this.coordJob, coordAction);
                    }
                    this.updateAction(this.coordJob, coordAction);
                    if (SLAService.isEnabled()) {
                        SLAOperations.updateRegistrationEvent(coordAction.getId());
                    }
                    this.queue(new CoordActionNotificationXCommand(coordAction), 100L);
                    this.queue(new CoordActionInputCheckXCommand(coordAction.getId(), coordAction.getJobId()), 100L);
                }
            } else {
                isError = true;
                throw new CommandException(ErrorCode.E1018, "part or all actions are not eligible to rerun!");
            }
            coordInfo = new CoordinatorActionInfo(coordActions);
            this.ret = coordInfo;
        }
        catch (XException xex) {
            isError = true;
            throw new CommandException(xex);
        }
        catch (JDOMException jex) {
            isError = true;
            throw new CommandException(ErrorCode.E0700, new Object[]{jex.getMessage(), jex});
        }
        catch (Exception ex) {
            isError = true;
            throw new CommandException(ErrorCode.E1018, ex.getMessage(), ex);
        }
        finally {
            if (isError) {
                this.transitToPrevious();
            }
        }
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.getPrevStatus() != null && this.coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.getPrevStatus());
            bundleStatusUpdate.call();
        }
    }

    @Override
    public void updateJob() {
        if (this.getPrevStatus() != null) {
            Job.Status coordJobStatus = this.getPrevStatus();
            if (coordJobStatus.equals((Object)Job.Status.PAUSED) || coordJobStatus.equals((Object)Job.Status.PAUSEDWITHERROR)) {
                this.coordJob.setStatus(coordJobStatus);
            }
            if (this.prevPending) {
                this.coordJob.setPending();
            } else {
                this.coordJob.resetPending();
            }
        }
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING, this.coordJob));
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
            if (EventHandlerService.isEnabled()) {
                this.generateEvents(this.coordJob, null);
            }
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public XLog getLog() {
        return this.LOG;
    }

    @Override
    public final void transitToNext() {
        this.prevStatus = this.coordJob.getStatus();
        if (this.prevStatus == Job.Status.SUCCEEDED || this.prevStatus == Job.Status.PAUSED || this.prevStatus == Job.Status.SUSPENDED || this.prevStatus == Job.Status.RUNNING) {
            this.coordJob.setStatus(Job.Status.RUNNING);
        } else {
            this.coordJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(Job.Status.RUNNINGWITHERROR));
        }
        this.coordJob.setStatus(StatusUtils.getStatusForCoordRerun(this.coordJob, this.prevStatus));
        this.coordJob.setPending();
    }

    private final void transitToPrevious() throws CommandException {
        this.coordJob.setStatus(this.getPrevStatus());
        if (!this.prevPending) {
            this.coordJob.resetPending();
        } else {
            this.coordJob.setPending();
        }
    }
}

