/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.util.XLog;

public class DefaultConnectionContext
implements ConnectionContext {
    protected Connection connection;
    protected String connectionFactoryName;
    private static XLog LOG = XLog.getLog(ConnectionContext.class);
    private ThreadLocal<Session> th = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnection(Properties props) throws NamingException, JMSException {
        InitialContext jndiContext = new InitialContext(props);
        this.connectionFactoryName = (String)jndiContext.getEnvironment().get("connectionFactoryNames");
        if (this.connectionFactoryName == null || this.connectionFactoryName.trim().length() == 0) {
            this.connectionFactoryName = "ConnectionFactory";
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)jndiContext.lookup(this.connectionFactoryName);
        LOG.info("Connecting with the following properties \n" + jndiContext.getEnvironment().toString());
        try {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException je) {
                    LOG.error((Object)"Error in JMS connection", (Throwable)je);
                }
            });
        }
        catch (JMSException e1) {
            LOG.error((Object)e1.getMessage(), e1);
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)e2.getMessage(), e2);
                }
                finally {
                    this.connection = null;
                }
            }
            throw e1;
        }
    }

    @Override
    public boolean isConnectionInitialized() {
        return this.connection != null;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.connection.setExceptionListener(exceptionListener);
    }

    @Override
    public Session createSession(int sessionOpts) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection is not initialized");
        }
        return this.connection.createSession(false, sessionOpts);
    }

    @Override
    public MessageConsumer createConsumer(Session session, String topicName) throws JMSException {
        Topic topic = session.createTopic(topicName);
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        return consumer;
    }

    @Override
    public MessageProducer createProducer(Session session, String topicName) throws JMSException {
        Topic topic = session.createTopic(topicName);
        MessageProducer producer = session.createProducer((Destination)topic);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                LOG.warn((Object)("Unable to close the connection " + this.connection), e);
            }
            finally {
                this.connection = null;
            }
        }
        this.th = null;
    }

    @Override
    public Session createThreadLocalSession(int sessionOpts) throws JMSException {
        Session session = this.th.get();
        if (session != null) {
            return session;
        }
        this.th.remove();
        session = this.createSession(sessionOpts);
        this.th.set(session);
        return session;
    }

    @Override
    public MessageConsumer createConsumer(Session session, String topicName, String selector) throws JMSException {
        Topic topic = session.createTopic(topicName);
        MessageConsumer consumer = session.createConsumer((Destination)topic, selector);
        return consumer;
    }
}

