/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.PollablePriorityDelayQueue;
import org.apache.oozie.util.PriorityDelayQueue;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;

public class CallableQueueService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP = "callablequeue";
    private static final String INSTR_IN_QUEUE_TIME_TIMER = "time.in.queue";
    private static final String INSTR_EXECUTED_COUNTER = "executed";
    private static final String INSTR_FAILED_COUNTER = "failed";
    private static final String INSTR_QUEUED_COUNTER = "queued";
    private static final String INSTR_QUEUE_SIZE_SAMPLER = "queue.size";
    private static final String INSTR_THREADS_ACTIVE_SAMPLER = "threads.active";
    public static final String CONF_PREFIX = "oozie.service.CallableQueueService.";
    public static final String CONF_QUEUE_SIZE = "oozie.service.CallableQueueService.queue.size";
    public static final String CONF_THREADS = "oozie.service.CallableQueueService.threads";
    public static final String CONF_CALLABLE_CONCURRENCY = "oozie.service.CallableQueueService.callable.concurrency";
    public static final String CONF_CALLABLE_NEXT_ELIGIBLE = "oozie.service.CallableQueueService.callable.next.eligible";
    public static final String CONF_CALLABLE_INTERRUPT_TYPES = "oozie.service.CallableQueueService.InterruptTypes";
    public static final String CONF_CALLABLE_INTERRUPT_MAP_MAX_SIZE = "oozie.service.CallableQueueService.InterruptMapMaxSize";
    public static final int CONCURRENCY_DELAY = 500;
    public static final int SAFE_MODE_DELAY = 60000;
    private final Map<String, AtomicInteger> activeCallables = new HashMap<String, AtomicInteger>();
    private final Map<String, Date> uniqueCallables = new ConcurrentHashMap<String, Date>();
    private final ConcurrentHashMap<String, Set<XCallable<?>>> interruptCommandsMap = new ConcurrentHashMap();
    public static final HashSet<String> INTERRUPT_TYPES = new HashSet();
    private int interruptMapMaxSize;
    private int maxCallableConcurrency;
    private XLog log = XLog.getLog(this.getClass());
    private int queueSize;
    private PriorityDelayQueue<CallableWrapper> queue;
    private ThreadPoolExecutor executor;
    private Instrumentation instrumentation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callableBegin(XCallable<?> callable) {
        Map<String, AtomicInteger> map = this.activeCallables;
        synchronized (map) {
            AtomicInteger counter = this.activeCallables.get(callable.getType());
            if (counter == null) {
                counter = new AtomicInteger(1);
                this.activeCallables.put(callable.getType(), counter);
                return true;
            }
            int i = counter.incrementAndGet();
            boolean bl = i <= this.maxCallableConcurrency;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callableEnd(XCallable<?> callable) {
        Map<String, AtomicInteger> map = this.activeCallables;
        synchronized (map) {
            AtomicInteger counter = this.activeCallables.get(callable.getType());
            if (counter == null) {
                throw new IllegalStateException("It should not happen");
            }
            counter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callableReachMaxConcurrency(XCallable<?> callable) {
        Map<String, AtomicInteger> map = this.activeCallables;
        synchronized (map) {
            AtomicInteger counter = this.activeCallables.get(callable.getType());
            if (counter == null) {
                return true;
            }
            int i = counter.get();
            boolean bl = i < this.maxCallableConcurrency;
            return bl;
        }
    }

    private void incrCounter(String name, int count) {
        if (this.instrumentation != null) {
            this.instrumentation.incr(INSTRUMENTATION_GROUP, name, count);
        }
    }

    private void addInQueueCron(Instrumentation.Cron cron) {
        if (this.instrumentation != null) {
            this.instrumentation.addCron(INSTRUMENTATION_GROUP, INSTR_IN_QUEUE_TIME_TIMER, cron);
        }
    }

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        this.queueSize = ConfigurationService.getInt(conf, CONF_QUEUE_SIZE);
        int threads = ConfigurationService.getInt(conf, CONF_THREADS);
        boolean callableNextEligible = ConfigurationService.getBoolean(conf, CONF_CALLABLE_NEXT_ELIGIBLE);
        for (String type : ConfigurationService.getStrings(conf, CONF_CALLABLE_INTERRUPT_TYPES)) {
            this.log.debug("Adding interrupt type [{0}]", type);
            INTERRUPT_TYPES.add(type);
        }
        this.queue = !callableNextEligible ? new PriorityDelayQueue<CallableWrapper>(3, 30000L, TimeUnit.MILLISECONDS, this.queueSize){

            @Override
            protected void debug(String msgTemplate, Object ... msgArgs) {
                CallableQueueService.this.log.trace(msgTemplate, msgArgs);
            }
        } : new PollablePriorityDelayQueue<CallableWrapper>(3, 30000L, TimeUnit.MILLISECONDS, this.queueSize){

            @Override
            protected void debug(String msgTemplate, Object ... msgArgs) {
                CallableQueueService.this.log.trace(msgTemplate, msgArgs);
            }

            @Override
            protected boolean eligibleToPoll(PriorityDelayQueue.QueueElement<?> element) {
                if (element != null) {
                    CallableWrapper wrapper = (CallableWrapper)element;
                    if (element.getElement() != null) {
                        return CallableQueueService.this.callableReachMaxConcurrency((XCallable)wrapper.getElement());
                    }
                }
                return false;
            }
        };
        this.interruptMapMaxSize = ConfigurationService.getInt(conf, CONF_CALLABLE_INTERRUPT_MAP_MAX_SIZE);
        this.executor = new ThreadPoolExecutor(threads, threads, 10L, TimeUnit.SECONDS, this.queue){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                super.beforeExecute(t, r);
                XLog.Info.get().clear();
            }
        };
        for (int i = 0; i < threads; ++i) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        CallableQueueService.this.log.warn("Could not warm up threadpool {0}", ex.getMessage(), ex);
                    }
                }
            });
        }
        this.maxCallableConcurrency = ConfigurationService.getInt(conf, CONF_CALLABLE_CONCURRENCY);
    }

    @Override
    public void destroy() {
        try {
            long limit = System.currentTimeMillis() + 30000L;
            this.executor.shutdown();
            this.queue.clear();
            while (!this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.log.info("Waiting for executor to shutdown");
                if (System.currentTimeMillis() <= limit) continue;
                this.log.warn("Gave up, continuing without waiting for executor to shutdown");
                break;
            }
        }
        catch (InterruptedException ex) {
            this.log.warn(ex);
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return CallableQueueService.class;
    }

    public synchronized int queueSize() {
        return this.queue.size();
    }

    private synchronized boolean queue(CallableWrapper wrapper, boolean ignoreQueueSize) {
        if (!ignoreQueueSize && this.queue.size() >= this.queueSize) {
            this.log.warn("queue full, ignoring queuing for [{0}]", ((XCallable)wrapper.getElement()).getKey());
            return false;
        }
        if (!this.executor.isShutdown()) {
            if (wrapper.filterDuplicates()) {
                wrapper.addToUniqueCallables();
                try {
                    this.executor.execute(wrapper);
                }
                catch (Throwable ree) {
                    wrapper.removeFromUniqueCallables();
                    throw new RuntimeException(ree);
                }
            }
        } else {
            this.log.warn("Executor shutting down, ignoring queueing of [{0}]", ((XCallable)wrapper.getElement()).getKey());
        }
        return true;
    }

    public boolean queue(XCallable<?> callable) {
        return this.queue(callable, 0L);
    }

    public boolean queueSerial(List<? extends XCallable<?>> callables) {
        return this.queueSerial(callables, 0L);
    }

    public synchronized boolean queue(XCallable<?> callable, long delay) {
        if (callable == null) {
            return true;
        }
        boolean queued = false;
        if (Services.get().getSystemMode() == OozieClient.SYSTEM_MODE.SAFEMODE) {
            this.log.warn("[queue] System is in SAFEMODE. Hence no callable is queued. current queue size " + this.queue.size());
        } else {
            this.checkInterruptTypes(callable);
            queued = this.queue(new CallableWrapper(callable, delay), false);
            if (queued) {
                this.incrCounter(INSTR_QUEUED_COUNTER, 1);
            } else {
                this.log.warn("Could not queue callable");
            }
        }
        return queued;
    }

    public synchronized boolean queueSerial(List<? extends XCallable<?>> callables, long delay) {
        boolean queued;
        if (callables == null || callables.size() == 0) {
            queued = true;
        } else if (callables.size() == 1) {
            queued = this.queue(callables.get(0), delay);
        } else {
            CompositeCallable callable = new CompositeCallable(callables);
            queued = this.queue(callable, delay);
            if (queued) {
                this.incrCounter(INSTR_QUEUED_COUNTER, callables.size());
            }
        }
        return queued;
    }

    @Override
    public void instrument(Instrumentation instr) {
        this.instrumentation = instr;
        instr.addSampler(INSTRUMENTATION_GROUP, INSTR_QUEUE_SIZE_SAMPLER, 60, 1, new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return CallableQueueService.this.queue.size();
            }
        });
        instr.addSampler(INSTRUMENTATION_GROUP, INSTR_THREADS_ACTIVE_SAMPLER, 60, 1, new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return CallableQueueService.this.executor.getActiveCount();
            }
        });
    }

    public Set<XCallable<?>> checkInterrupts(String lockKey) {
        if (lockKey != null) {
            return this.interruptCommandsMap.remove(lockKey);
        }
        return null;
    }

    public void checkInterruptTypes(XCallable<?> callable) {
        if (callable instanceof CompositeCallable && ((CompositeCallable)callable).getCallables() != null) {
            for (XCallable<?> singleCallable : ((CompositeCallable)callable).getCallables()) {
                if (!INTERRUPT_TYPES.contains(singleCallable.getType())) continue;
                this.insertCallableIntoInterruptMap(singleCallable);
            }
        } else if (INTERRUPT_TYPES.contains(callable.getType())) {
            this.insertCallableIntoInterruptMap(callable);
        }
    }

    public void insertCallableIntoInterruptMap(XCallable<?> callable) {
        if (this.interruptCommandsMap.size() < this.interruptMapMaxSize) {
            Set newSet = Collections.synchronizedSet(new LinkedHashSet());
            Set<XCallable<?>> interruptSet = this.interruptCommandsMap.putIfAbsent(callable.getEntityKey(), newSet);
            if (interruptSet == null) {
                interruptSet = newSet;
            }
            if (interruptSet.add(callable)) {
                this.log.trace("Inserting an interrupt element [{0}] to the interrupt map", callable.toString());
            } else {
                this.log.trace("Interrupt element [{0}] already present", callable.toString());
            }
        } else {
            this.log.warn("The interrupt map reached max size of [{0}], an interrupt element [{1}] will not added to the map [{1}]", this.interruptCommandsMap.size(), callable.toString());
        }
    }

    public List<String> getQueueDump() {
        ArrayList<String> list = new ArrayList<String>();
        for (PriorityDelayQueue.QueueElement<CallableWrapper> queueElement : this.queue) {
            if (queueElement.toString() == null) continue;
            list.add(queueElement.toString());
        }
        return list;
    }

    public List<String> getUniqueDump() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Date> entry : this.uniqueCallables.entrySet()) {
            list.add(entry.toString());
        }
        return list;
    }

    class CompositeCallable
    implements XCallable<Void> {
        private List<XCallable<?>> callables;
        private String name;
        private int priority;
        private long createdTime;

        public CompositeCallable(List<? extends XCallable<?>> callables) {
            this.callables = new ArrayList(callables);
            this.priority = 0;
            this.createdTime = Long.MAX_VALUE;
            StringBuilder sb = new StringBuilder();
            String separator = "[";
            for (XCallable<?> callable : callables) {
                this.priority = Math.max(this.priority, callable.getPriority());
                this.createdTime = Math.min(this.createdTime, callable.getCreatedTime());
                sb.append(separator).append(callable.getName());
                separator = ",";
            }
            sb.append("]");
            this.name = sb.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return "#composite#" + this.callables.get(0).getType();
        }

        @Override
        public String getKey() {
            return "#composite#" + this.callables.get(0).getKey();
        }

        @Override
        public String getEntityKey() {
            return "#composite#" + this.callables.get(0).getEntityKey();
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public long getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public void setInterruptMode(boolean mode) {
        }

        @Override
        public boolean inInterruptMode() {
            return false;
        }

        public List<XCallable<?>> getCallables() {
            return this.callables;
        }

        @Override
        public Void call() throws Exception {
            XLog log = XLog.getLog(this.getClass());
            for (XCallable<?> callable : this.callables) {
                log.trace("executing callable [{0}]", callable.getName());
                try {
                    callable.call();
                    CallableQueueService.this.incrCounter(CallableQueueService.INSTR_EXECUTED_COUNTER, 1);
                    log.trace("executed callable [{0}]", callable.getName());
                }
                catch (Exception ex) {
                    CallableQueueService.this.incrCounter(CallableQueueService.INSTR_FAILED_COUNTER, 1);
                    log.warn("exception callable [{0}], {1}", callable.getName(), ex.getMessage(), ex);
                }
            }
            CallableQueueService.this.incrCounter(CallableQueueService.INSTR_EXECUTED_COUNTER, -1);
            return null;
        }

        public String toString() {
            if (this.callables.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int size = this.callables.size();
            for (int i = 0; i < size; ++i) {
                XCallable<?> callable = this.callables.get(i);
                sb.append("(");
                sb.append(callable.toString());
                if (i + 1 == size) {
                    sb.append(")");
                    continue;
                }
                sb.append("),");
            }
            return sb.toString();
        }

        public boolean removeDuplicates() {
            HashSet<String> set = new HashSet<String>();
            ArrayList filteredCallables = new ArrayList();
            if (this.callables.size() == 0) {
                return false;
            }
            for (XCallable<?> callable : this.callables) {
                if (CallableQueueService.this.uniqueCallables.containsKey(callable.getKey()) || set.contains(callable.getKey())) continue;
                filteredCallables.add(callable);
                set.add(callable.getKey());
            }
            this.callables = filteredCallables;
            return this.callables.size() != 0;
        }

        public void addToUniqueCallables() {
            for (XCallable<?> callable : this.callables) {
                ((ConcurrentHashMap)CallableQueueService.this.uniqueCallables).putIfAbsent(callable.getKey(), new Date());
            }
        }

        public void removeFromUniqueCallables() {
            for (XCallable<?> callable : this.callables) {
                CallableQueueService.this.uniqueCallables.remove(callable.getKey());
            }
        }
    }

    class CallableWrapper
    extends PriorityDelayQueue.QueueElement<XCallable<?>>
    implements Runnable {
        private Instrumentation.Cron cron;

        public CallableWrapper(XCallable<?> callable, long delay) {
            super(callable, callable.getPriority(), delay, TimeUnit.MILLISECONDS);
            this.cron = new Instrumentation.Cron();
            this.cron.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            XCallable callable;
            block9: {
                callable = null;
                this.removeFromUniqueCallables();
                if (Services.get().getSystemMode() != OozieClient.SYSTEM_MODE.SAFEMODE) break block9;
                CallableQueueService.this.log.info("Oozie is in SAFEMODE, requeuing callable [{0}] with [{1}]ms delay", ((XCallable)this.getElement()).getType(), 60000);
                this.setDelay(60000L, TimeUnit.MILLISECONDS);
                CallableQueueService.this.queue(this, true);
                if (callable == null) return;
                CallableQueueService.this.callableEnd(callable);
                return;
            }
            try {
                callable = (XCallable)this.getElement();
                if (CallableQueueService.this.callableBegin(callable)) {
                    this.cron.stop();
                    CallableQueueService.this.addInQueueCron(this.cron);
                    XLog log = XLog.getLog(this.getClass());
                    log.trace("executing callable [{0}]", callable.getName());
                    try {
                        callable.call();
                        CallableQueueService.this.incrCounter(CallableQueueService.INSTR_EXECUTED_COUNTER, 1);
                        log.trace("executed callable [{0}]", callable.getName());
                    }
                    catch (Exception ex) {
                        CallableQueueService.this.incrCounter(CallableQueueService.INSTR_FAILED_COUNTER, 1);
                        log.warn("exception callable [{0}], {1}", callable.getName(), ex.getMessage(), ex);
                    }
                } else {
                    CallableQueueService.this.log.warn("max concurrency for callable [{0}] exceeded, requeueing with [{1}]ms delay", callable.getType(), 500);
                    this.setDelay(500L, TimeUnit.MILLISECONDS);
                    CallableQueueService.this.queue(this, true);
                    CallableQueueService.this.incrCounter(callable.getType() + "#exceeded.concurrency", 1);
                }
                if (callable == null) return;
            }
            catch (Throwable t) {
                try {
                    CallableQueueService.this.incrCounter(CallableQueueService.INSTR_FAILED_COUNTER, 1);
                    CallableQueueService.this.log.warn("exception callable [{0}], {1}", callable == null ? "N/A" : callable.getName(), t.getMessage(), t);
                    if (callable == null) return;
                }
                catch (Throwable throwable) {
                    if (callable == null) throw throwable;
                    CallableQueueService.this.callableEnd(callable);
                    throw throwable;
                }
                CallableQueueService.this.callableEnd(callable);
                return;
            }
            CallableQueueService.this.callableEnd(callable);
            return;
        }

        public boolean filterDuplicates() {
            XCallable callable = (XCallable)this.getElement();
            if (callable instanceof CompositeCallable) {
                return ((CompositeCallable)callable).removeDuplicates();
            }
            return !CallableQueueService.this.uniqueCallables.containsKey(callable.getKey());
        }

        public void addToUniqueCallables() {
            XCallable callable = (XCallable)this.getElement();
            if (callable instanceof CompositeCallable) {
                ((CompositeCallable)callable).addToUniqueCallables();
            } else {
                ((ConcurrentHashMap)CallableQueueService.this.uniqueCallables).putIfAbsent(callable.getKey(), new Date());
            }
        }

        public void removeFromUniqueCallables() {
            XCallable callable = (XCallable)this.getElement();
            if (callable instanceof CompositeCallable) {
                ((CompositeCallable)callable).removeFromUniqueCallables();
            } else {
                CallableQueueService.this.uniqueCallables.remove(callable.getKey());
            }
        }
    }
}

