/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;

public class XLogStreamingService
implements Service,
Instrumentable {
    private static final String CONF_PREFIX = "oozie.service.XLogStreamingService.";
    public static final String STREAM_BUFFER_LEN = "oozie.service.XLogStreamingService.buffer.len";
    protected int bufferLen;

    @Override
    public void init(Services services) throws ServiceException {
        this.bufferLen = ConfigurationService.getInt(services.getConf(), STREAM_BUFFER_LEN);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return XLogStreamingService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
    }

    public void streamLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.getLogOverWS()) {
            new XLogStreamer(filter, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
        } else {
            writer.write("Log streaming disabled!!");
        }
    }

    public void streamErrorLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.isErrorLogEnabled()) {
            new XLogStreamer(filter, xLogService.getOozieErrorLogPath(), xLogService.getOozieErrorLogName(), xLogService.getOozieErrorLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
        } else {
            writer.write("Error Log is disabled!!");
        }
    }

    public void streamAuditLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.isAuditLogEnabled()) {
            new XLogStreamer(filter, xLogService.getOozieAuditLogPath(), xLogService.getOozieAuditLogName(), xLogService.getOozieAuditLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
        } else {
            writer.write("Audit Log is disabled!!");
        }
    }

    public int getBufferLen() {
        return this.bufferLen;
    }
}

