/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.ri.impl;

import com.google.common.cache.CacheBuilder;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.pentaho.caching.api.Constants;
import org.pentaho.caching.ri.impl.WrappedCache;
import org.pentaho.caching.spi.AbstractCacheManager;

public class GuavaCacheManager
extends AbstractCacheManager {
    public <K, V, C extends Configuration<K, V>> Cache<K, V> newCache(final String cacheName, final C configuration) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (configuration instanceof CompleteConfiguration) {
            this.configureCacheBuilder((CompleteConfiguration)configuration, (CacheBuilder<Object, Object>)cacheBuilder);
        }
        return new WrappedCache<K, V>(cacheBuilder.build()){

            public String getName() {
                return cacheName;
            }

            public CacheManager getCacheManager() {
                return GuavaCacheManager.this;
            }

            @Override
            public void close() {
                if (!this.isClosed()) {
                    super.close();
                    GuavaCacheManager.this.destroyCache(cacheName);
                }
            }

            public <T extends Configuration<K, V>> T getConfiguration(Class<T> clazz) {
                return (T)((Configuration)Constants.unwrap((Object)configuration, clazz));
            }
        };
    }

    <K, V> void configureCacheBuilder(CompleteConfiguration<K, V> completeConfiguration, CacheBuilder<Object, Object> cacheBuilder) {
        Duration expiryForUpdate;
        ExpiryPolicy expiryPolicy = (ExpiryPolicy)completeConfiguration.getExpiryPolicyFactory().create();
        Duration expiryForAccess = expiryPolicy.getExpiryForAccess();
        if (expiryForAccess != null && !expiryForAccess.isEternal()) {
            cacheBuilder.expireAfterAccess(expiryForAccess.getDurationAmount(), expiryForAccess.getTimeUnit());
        }
        if ((expiryForUpdate = expiryPolicy.getExpiryForUpdate()) != null && !expiryForUpdate.isEternal()) {
            cacheBuilder.expireAfterWrite(expiryForUpdate.getDurationAmount(), expiryForUpdate.getTimeUnit());
        }
    }
}

