/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.jdbc.impl;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.pentaho.big.data.api.initializer.ClusterInitializer;
import org.pentaho.big.data.api.jdbc.JdbcUrlParser;
import org.pentaho.big.data.api.jdbc.impl.DriverLocatorImpl;
import org.pentaho.big.data.api.jdbc.impl.HasRegisterDriver;
import org.pentaho.big.data.api.jdbc.impl.LazyDelegatingDriver;
import org.pentaho.di.core.database.DelegatingDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInitializingDriver
implements Driver {
    private static final List<String> BIG_DATA_DRIVER_URL_PATTERNS = new ArrayList<String>();
    @VisibleForTesting
    protected static Logger logger = LoggerFactory.getLogger(ClusterInitializingDriver.class);
    private final ClusterInitializer clusterInitializer;
    private final JdbcUrlParser jdbcUrlParser;

    public ClusterInitializingDriver(ClusterInitializer clusterInitializer, JdbcUrlParser jdbcUrlParser, DriverLocatorImpl driverRegistry) {
        this(clusterInitializer, jdbcUrlParser, driverRegistry, null);
    }

    public ClusterInitializingDriver(ClusterInitializer clusterInitializer, JdbcUrlParser jdbcUrlParser, DriverLocatorImpl driverRegistry, Integer numLazyProxies) {
        this(clusterInitializer, jdbcUrlParser, driverRegistry, numLazyProxies, DriverManager::registerDriver);
    }

    public ClusterInitializingDriver(ClusterInitializer clusterInitializer, JdbcUrlParser jdbcUrlParser, DriverLocatorImpl driverRegistry, Integer numLazyProxies, HasRegisterDriver hasRegisterDriver) {
        this.clusterInitializer = clusterInitializer;
        this.jdbcUrlParser = jdbcUrlParser;
        int lazyProxies = Optional.ofNullable(numLazyProxies).orElse(5);
        try {
            hasRegisterDriver.registerDriver((Driver)new DelegatingDriver((Driver)this));
        }
        catch (SQLException e) {
            logger.warn("Unable to register cluster initializing driver", (Throwable)e);
        }
        for (int i = 0; i < lazyProxies; ++i) {
            try {
                new LazyDelegatingDriver(driverRegistry, hasRegisterDriver);
                continue;
            }
            catch (SQLException e) {
                logger.warn("Failed to register " + LazyDelegatingDriver.class.getName(), (Throwable)e);
            }
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.checkIfUsesBigDataDriver(url)) {
            this.initializeCluster(url);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (this.checkIfUsesBigDataDriver(url)) {
            this.initializeCluster(url);
        }
        return false;
    }

    boolean checkIfUsesBigDataDriver(String url) {
        List<String> urlPatterns = this.getUrlPatternsForBigDataDrivers();
        for (String pattern : urlPatterns) {
            if (!url.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    List<String> getUrlPatternsForBigDataDrivers() {
        return BIG_DATA_DRIVER_URL_PATTERNS;
    }

    private void initializeCluster(String url) {
        try {
            this.clusterInitializer.initialize(null);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getClass().getName().contains("NoShimSpecifiedException")) {
                logger.debug("No shim specified", (Throwable)e);
            }
            logger.error("Failed to initialize cluster", (Throwable)e);
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:hive:.*");
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:hive2:.*");
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:impala:.*");
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:spark:.*");
    }
}

