/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.coprocessor.BaseMasterAndRegionObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;

public class BackupController
extends BaseMasterAndRegionObserver {
    private static final Log LOG = LogFactory.getLog((String)BackupController.class.getName());

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        MasterServices master = ctx.getEnvironment().getMasterServices();
        HTableDescriptor backupHTD = BackupSystemTable.getSystemTableDescriptor();
        try {
            master.createTable(backupHTD, null);
            LOG.info((Object)("Created " + BackupSystemTable.getTableNameAsString() + " table"));
        }
        catch (TableExistsException e) {
            LOG.info((Object)("Table " + BackupSystemTable.getTableNameAsString() + " already exists"));
        }
    }
}

