/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.regionserver;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.errorhandling.ForeignException;

public class LogRollBackupSubprocedurePool
implements Closeable,
Abortable {
    private static final Log LOG = LogFactory.getLog(LogRollBackupSubprocedurePool.class);
    private static final String CONCURENT_BACKUP_TASKS_KEY = "hbase.backup.region.concurrentTasks";
    private static final int DEFAULT_CONCURRENT_BACKUP_TASKS = 3;
    private final ExecutorCompletionService<Void> taskPool;
    private final ThreadPoolExecutor executor;
    private volatile boolean aborted;
    private final List<Future<Void>> futures = new ArrayList<Future<Void>>();
    private final String name;

    public LogRollBackupSubprocedurePool(String name, Configuration conf) {
        long keepAlive = conf.getLong("hbase.backup.timeout", 60000L);
        int threads = conf.getInt(CONCURENT_BACKUP_TASKS_KEY, 3);
        this.name = name;
        this.executor = new ThreadPoolExecutor(1, threads, keepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("rs(" + name + ")-backup-pool"));
        this.taskPool = new ExecutorCompletionService(this.executor);
    }

    public void submitTask(Callable<Void> task) {
        Future<Void> f = this.taskPool.submit(task);
        this.futures.add(f);
    }

    public boolean waitForOutstandingTasks() throws ForeignException {
        LOG.debug((Object)"Waiting for backup procedure to finish.");
        try {
            for (Future<Void> f : this.futures) {
                f.get();
            }
            boolean i$ = true;
            return i$;
        }
        catch (InterruptedException e) {
            if (this.aborted) {
                throw new ForeignException("Interrupted and found to be aborted while waiting for tasks!", e);
            }
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ForeignException) {
                throw (ForeignException)e.getCause();
            }
            throw new ForeignException(this.name, e.getCause());
        }
        finally {
            for (Future<Void> f : this.futures) {
                if (f.isDone()) continue;
                f.cancel(true);
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    public void abort(String why, Throwable e) {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        LOG.warn((Object)("Aborting because: " + why), e);
        this.executor.shutdownNow();
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

