/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.impl.BackupException;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupServerUtil {
    protected static final Log LOG = LogFactory.getLog(BackupServerUtil.class);
    public static final String LOGNAME_SEPARATOR = ".";

    private BackupServerUtil() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static void waitForSnapshot(HBaseProtos.SnapshotDescription snapshot, long max, SnapshotManager snapshotMgr, Configuration conf) throws IOException {
        boolean done = false;
        long start = EnvironmentEdgeManager.currentTime();
        int numRetries = conf.getInt("hbase.client.retries.number", 31);
        long maxPauseTime = max / (long)numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for snapshot '" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)snapshot) + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done) {
            try {
                long pause = conf.getLong("hbase.client.pause", 100L);
                long sleep = HBaseAdmin.getPauseTime((int)tries++, (long)pause);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug((Object)"Getting current status of snapshot ...");
            done = snapshotMgr.isSnapshotDone(snapshot);
        }
        if (!done) {
            throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshot);
        }
    }

    public static HashMap<String, Long> getRSLogTimestampMins(HashMap<TableName, HashMap<String, Long>> rsLogTimestampMap) {
        if (rsLogTimestampMap == null || rsLogTimestampMap.isEmpty()) {
            return null;
        }
        HashMap<String, Long> rsLogTimestampMins = new HashMap<String, Long>();
        HashMap rsLogTimestampMapByRS = new HashMap();
        for (Map.Entry<TableName, HashMap<String, Long>> tableEntry : rsLogTimestampMap.entrySet()) {
            TableName table = tableEntry.getKey();
            HashMap<String, Long> rsLogTimestamp = tableEntry.getValue();
            for (Map.Entry<String, Long> rsEntry : rsLogTimestamp.entrySet()) {
                String rs = rsEntry.getKey();
                Long ts = rsEntry.getValue();
                if (!rsLogTimestampMapByRS.containsKey(rs)) {
                    rsLogTimestampMapByRS.put(rs, new HashMap());
                    ((HashMap)rsLogTimestampMapByRS.get(rs)).put(table, ts);
                    continue;
                }
                ((HashMap)rsLogTimestampMapByRS.get(rs)).put(table, ts);
            }
        }
        for (String rs : rsLogTimestampMapByRS.keySet()) {
            rsLogTimestampMins.put(rs, BackupClientUtil.getMinValue((HashMap)((HashMap)rsLogTimestampMapByRS.get(rs))));
        }
        return rsLogTimestampMins;
    }

    public static void copyTableRegionInfo(BackupInfo backupContext, Configuration conf) throws IOException, InterruptedException {
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = conn.getAdmin();){
            for (TableName table : backupContext.getTables()) {
                if (!admin.tableExists(table)) {
                    LOG.warn((Object)("Table " + table + " does not exists, skipping it."));
                    continue;
                }
                LOG.debug((Object)("Attempting to copy table info for:" + table));
                HTableDescriptor orig = FSTableDescriptors.getTableDescriptorFromFs(fs, rootDir, table);
                Path target = new Path(backupContext.getBackupStatus(table).getTargetDir());
                FileSystem targetFs = target.getFileSystem(conf);
                FSTableDescriptors descriptors = new FSTableDescriptors(conf, targetFs, FSUtils.getRootDir(conf));
                descriptors.createTableDescriptorForTableDirectory(target, orig, false);
                LOG.debug((Object)"Finished copying tableinfo.");
                List regions = null;
                regions = admin.getTableRegions(table);
                LOG.debug((Object)("Starting to write region info for table " + table));
                for (HRegionInfo regionInfo : regions) {
                    Path regionDir = HRegion.getRegionDir(new Path(backupContext.getBackupStatus(table).getTargetDir()), regionInfo);
                    regionDir = new Path(backupContext.getBackupStatus(table).getTargetDir(), regionDir.getName());
                    BackupServerUtil.writeRegioninfoOnFilesystem(conf, targetFs, regionDir, regionInfo);
                }
                LOG.debug((Object)("Finished writing region info for table " + table));
            }
        }
        catch (IOException e) {
            throw new BackupException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRegioninfoOnFilesystem(Configuration conf, FileSystem fs, Path regionInfoDir, HRegionInfo regionInfo) throws IOException {
        byte[] content = regionInfo.toDelimitedByteArray();
        Path regionInfoFile = new Path(regionInfoDir, ".regioninfo");
        FsPermission perms = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        try (FSDataOutputStream out = FSUtils.create(fs, regionInfoFile, perms, null);){
            out.write(content);
        }
    }

    public static String parseHostNameFromLogFile(Path p) throws IOException {
        try {
            if (BackupServerUtil.isArchivedLogFile(p)) {
                return BackupClientUtil.parseHostFromOldLog((Path)p);
            }
            ServerName sname = DefaultWALProvider.getServerNameFromWALDirectoryName(p);
            return sname.getHostname() + ":" + sname.getPort();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    private static boolean isArchivedLogFile(Path p) {
        String oldLog = "/oldWALs/";
        return p.toString().contains(oldLog);
    }

    public static String getUniqueWALFileNamePart(String walFileName) throws IOException {
        return BackupServerUtil.getUniqueWALFileNamePart(new Path(walFileName));
    }

    public static String getUniqueWALFileNamePart(Path p) throws IOException {
        return p.getName();
    }

    public static long getFilesLength(FileSystem fs, Path dir) throws IOException {
        long totalLength = 0L;
        FileStatus[] files = FSUtils.listStatus(fs, dir);
        if (files != null) {
            for (FileStatus fileStatus : files) {
                if (fileStatus.isDirectory()) {
                    totalLength += BackupServerUtil.getFilesLength(fs, fileStatus.getPath());
                    continue;
                }
                totalLength += fileStatus.getLen();
            }
        }
        return totalLength;
    }

    public static ArrayList<BackupInfo> sortHistoryListDesc(ArrayList<BackupInfo> historyList) {
        ArrayList<BackupInfo> list = new ArrayList<BackupInfo>();
        TreeMap<String, BackupInfo> map = new TreeMap<String, BackupInfo>();
        for (BackupInfo h : historyList) {
            map.put(Long.toString(h.getStartTs()), h);
        }
        Iterator i = map.descendingKeySet().iterator();
        while (i.hasNext()) {
            list.add((BackupInfo)map.get(i.next()));
        }
        return list;
    }

    public static List<String> getListOfWALFiles(Configuration c) throws IOException {
        Path rootDir = FSUtils.getRootDir(c);
        Path logDir = new Path(rootDir, "WALs");
        Path oldLogDir = new Path(rootDir, "oldWALs");
        ArrayList<String> logFiles = new ArrayList();
        FileSystem fs = FileSystem.get((Configuration)c);
        logFiles = BackupClientUtil.getFiles((FileSystem)fs, (Path)logDir, logFiles, null);
        logFiles = BackupClientUtil.getFiles((FileSystem)fs, (Path)oldLogDir, logFiles, null);
        return logFiles;
    }

    public static List<String> getListOfWALFiles(Configuration c, PathFilter filter) throws IOException {
        Path rootDir = FSUtils.getRootDir(c);
        Path logDir = new Path(rootDir, "WALs");
        Path oldLogDir = new Path(rootDir, "oldWALs");
        ArrayList<String> logFiles = new ArrayList();
        FileSystem fs = FileSystem.get((Configuration)c);
        logFiles = BackupClientUtil.getFiles((FileSystem)fs, (Path)logDir, logFiles, (PathFilter)filter);
        logFiles = BackupClientUtil.getFiles((FileSystem)fs, (Path)oldLogDir, logFiles, (PathFilter)filter);
        return logFiles;
    }

    public static List<String> getWALFilesOlderThan(Configuration c, final HashMap<String, Long> hostTimestampMap) throws IOException {
        Path rootDir = FSUtils.getRootDir(c);
        Path logDir = new Path(rootDir, "WALs");
        Path oldLogDir = new Path(rootDir, "oldWALs");
        ArrayList<String> logFiles = new ArrayList();
        PathFilter filter = new PathFilter(){

            public boolean accept(Path p) {
                try {
                    if (DefaultWALProvider.isMetaFile(p)) {
                        return false;
                    }
                    String host = BackupServerUtil.parseHostNameFromLogFile(p);
                    if (host == null) {
                        return false;
                    }
                    Long oldTimestamp = (Long)hostTimestampMap.get(host);
                    Long currentLogTS = BackupClientUtil.getCreationTime((Path)p);
                    return currentLogTS <= oldTimestamp;
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    return false;
                }
            }
        };
        FileSystem fs = FileSystem.get((Configuration)c);
        logFiles = BackupClientUtil.getFiles((FileSystem)fs, (Path)logDir, logFiles, (PathFilter)filter);
        logFiles = BackupClientUtil.getFiles((FileSystem)fs, (Path)oldLogDir, logFiles, (PathFilter)filter);
        return logFiles;
    }

    public static String join(TableName[] names) {
        StringBuilder sb = new StringBuilder();
        String sep = ",";
        for (TableName s : names) {
            sb.append(sep).append(s.getNameAsString());
        }
        return sb.toString();
    }

    public static TableName[] parseTableNames(String tables) {
        if (tables == null) {
            return null;
        }
        String[] tableArray = tables.split(",");
        TableName[] ret = new TableName[tableArray.length];
        for (int i = 0; i < tableArray.length; ++i) {
            ret[i] = TableName.valueOf((String)tableArray[i]);
        }
        return ret;
    }

    public static void cleanupBackupData(BackupInfo context, Configuration conf) throws IOException {
        BackupServerUtil.cleanupHLogDir(context, conf);
        BackupServerUtil.cleanupTargetDir(context, conf);
    }

    private static void cleanupHLogDir(BackupInfo backupContext, Configuration conf) throws IOException {
        String logDir = backupContext.getHLogTargetDir();
        if (logDir == null) {
            LOG.warn((Object)("No log directory specified for " + backupContext.getBackupId()));
            return;
        }
        Path rootPath = new Path(logDir).getParent();
        FileSystem fs = FileSystem.get((URI)rootPath.toUri(), (Configuration)conf);
        FileStatus[] files = FSUtils.listStatus(fs, rootPath);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            LOG.debug((Object)("Delete log files: " + file.getPath().getName()));
            if (FSUtils.delete(fs, file.getPath(), true)) continue;
            LOG.warn((Object)("Could not delete files in " + file.getPath()));
        }
    }

    private static void cleanupTargetDir(BackupInfo backupContext, Configuration conf) {
        try {
            LOG.debug((Object)("Trying to cleanup up target dir : " + backupContext.getBackupId()));
            String targetDir = backupContext.getTargetRootDir();
            if (targetDir == null) {
                LOG.warn((Object)("No target directory specified for " + backupContext.getBackupId()));
                return;
            }
            FileSystem outputFs = FileSystem.get((URI)new Path(backupContext.getTargetRootDir()).toUri(), (Configuration)conf);
            for (TableName table : backupContext.getTables()) {
                Path tableDir;
                FileStatus[] backups;
                Path targetDirPath = new Path(HBackupFileSystem.getTableBackupDir(backupContext.getTargetRootDir(), backupContext.getBackupId(), table));
                if (outputFs.delete(targetDirPath, true)) {
                    LOG.info((Object)("Cleaning up backup data at " + targetDirPath.toString() + " done."));
                } else {
                    LOG.info((Object)("No data has been found in " + targetDirPath.toString() + LOGNAME_SEPARATOR));
                }
                if ((backups = FSUtils.listStatus(outputFs, tableDir = targetDirPath.getParent())) != null && backups.length != 0) continue;
                if (outputFs.delete(tableDir, true)) {
                    LOG.debug((Object)(tableDir.toString() + " is empty, remove it."));
                    continue;
                }
                LOG.warn((Object)("Could not delete " + tableDir));
            }
        }
        catch (IOException e1) {
            LOG.error((Object)("Cleaning up backup data of " + backupContext.getBackupId() + " at " + backupContext.getTargetRootDir() + " failed due to " + e1.getMessage() + LOGNAME_SEPARATOR));
        }
    }
}

