/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupRestoreServerFactory;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.IncrementalRestoreService;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RestoreServerUtil {
    public static final Log LOG = LogFactory.getLog(RestoreServerUtil.class);
    private final String[] ignoreDirs = new String[]{"recovered.edits"};
    protected Configuration conf = null;
    protected Path backupRootPath;
    protected String backupId;
    protected FileSystem fs;
    private final String RESTORE_TMP_PATH = "/tmp";
    private final Path restoreTmpPath;
    private final HashMap<TableName, Path> snapshotMap = new HashMap();

    public RestoreServerUtil(Configuration conf, Path backupRootPath, String backupId) throws IOException {
        this.conf = conf;
        this.backupRootPath = backupRootPath;
        this.backupId = backupId;
        this.fs = backupRootPath.getFileSystem(conf);
        this.restoreTmpPath = new Path(conf.get("hbase.fs.tmp.dir") != null ? conf.get("hbase.fs.tmp.dir") : "/tmp", "restore");
    }

    Path getTableArchivePath(TableName tableName) throws IOException {
        Path baseDir = new Path(HBackupFileSystem.getTableBackupPath(tableName, this.backupRootPath, this.backupId), "archive");
        Path dataDir = new Path(baseDir, "data");
        Path archivePath = new Path(dataDir, tableName.getNamespaceAsString());
        Path tableArchivePath = new Path(archivePath, tableName.getQualifierAsString());
        if (!this.fs.exists(tableArchivePath) || !this.fs.getFileStatus(tableArchivePath).isDirectory()) {
            LOG.debug((Object)("Folder tableArchivePath: " + tableArchivePath.toString() + " does not exists"));
            tableArchivePath = null;
        }
        return tableArchivePath;
    }

    ArrayList<Path> getRegionList(TableName tableName) throws FileNotFoundException, IOException {
        FileStatus[] children;
        Path tableArchivePath = this.getTableArchivePath(tableName);
        ArrayList<Path> regionDirList = new ArrayList<Path>();
        for (FileStatus childStatus : children = this.fs.listStatus(tableArchivePath)) {
            Path child = childStatus.getPath();
            regionDirList.add(child);
        }
        return regionDirList;
    }

    public void incrementalRestoreTable(Path[] logDirs, TableName[] tableNames, TableName[] newTableNames) throws IOException {
        if (tableNames.length != newTableNames.length) {
            throw new IOException("Number of source tables and target tables does not match!");
        }
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
             Admin admin = conn.getAdmin();){
            for (TableName tableName : newTableNames) {
                if (admin.tableExists(tableName)) continue;
                admin.close();
                throw new IOException("HBase table " + tableName + " does not exist. Create the table first, e.g. by restoring a full backup.");
            }
            IncrementalRestoreService restoreService = BackupRestoreServerFactory.getIncrementalRestoreService(this.conf);
            restoreService.run(logDirs, tableNames, newTableNames);
        }
    }

    public void fullRestoreTable(Path tableBackupPath, TableName tableName, TableName newTableName, boolean converted, boolean truncateIfExists) throws IOException {
        this.restoreTableAndCreate(tableName, newTableName, tableBackupPath, converted, truncateIfExists);
    }

    static Path getTableSnapshotPath(Path backupRootPath, TableName tableName, String backupId) {
        return new Path(HBackupFileSystem.getTableBackupPath(tableName, backupRootPath, backupId), ".hbase-snapshot");
    }

    Path getTableInfoPath(TableName tableName) throws FileNotFoundException, IOException {
        FileStatus snapshot;
        FileStatus[] snapshots;
        Path tableSnapShotPath = RestoreServerUtil.getTableSnapshotPath(this.backupRootPath, tableName, this.backupId);
        Path tableInfoPath = null;
        FileStatus[] arr$ = snapshots = this.fs.listStatus(tableSnapShotPath);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(tableInfoPath = (snapshot = arr$[i$]).getPath()).getName().endsWith("data.manifest"); ++i$) {
        }
        return tableInfoPath;
    }

    HTableDescriptor getTableDesc(TableName tableName) throws FileNotFoundException, IOException {
        HBaseProtos.SnapshotDescription desc;
        Path tableInfoPath = this.getTableInfoPath(tableName);
        SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, tableInfoPath, desc = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, tableInfoPath));
        HTableDescriptor tableDescriptor = manifest.getTableDescriptor();
        if (!tableDescriptor.getTableName().equals((Object)tableName)) {
            LOG.error((Object)("couldn't find Table Desc for table: " + tableName + " under tableInfoPath: " + tableInfoPath.toString()));
            LOG.error((Object)("tableDescriptor.getNameAsString() = " + tableDescriptor.getNameAsString()));
            throw new FileNotFoundException("couldn't find Table Desc for table: " + tableName + " under tableInfoPath: " + tableInfoPath.toString());
        }
        return tableDescriptor;
    }

    Path checkLocalAndBackup(Path tableArchivePath) throws IOException {
        boolean isCopyNeeded = false;
        FileSystem srcFs = tableArchivePath.getFileSystem(this.conf);
        FileSystem desFs = FileSystem.get((Configuration)this.conf);
        if (tableArchivePath.getName().startsWith("/")) {
            isCopyNeeded = true;
        } else if (srcFs.getUri().equals(desFs.getUri())) {
            LOG.debug((Object)("cluster hold the backup image: " + srcFs.getUri() + "; local cluster node: " + desFs.getUri()));
            isCopyNeeded = true;
        }
        if (isCopyNeeded) {
            LOG.debug((Object)("File " + tableArchivePath + " on local cluster, back it up before restore"));
            if (desFs.exists(this.restoreTmpPath)) {
                try {
                    desFs.delete(this.restoreTmpPath, true);
                }
                catch (IOException e) {
                    LOG.debug((Object)("Failed to delete path: " + this.restoreTmpPath + ", need to check whether restore target DFS cluster is healthy"));
                }
            }
            FileUtil.copy((FileSystem)srcFs, (Path)tableArchivePath, (FileSystem)desFs, (Path)this.restoreTmpPath, (boolean)false, (Configuration)this.conf);
            LOG.debug((Object)("Copied to temporary path on local cluster: " + this.restoreTmpPath));
            tableArchivePath = this.restoreTmpPath;
        }
        return tableArchivePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreTableAndCreate(TableName tableName, TableName newTableName, Path tableBackupPath, boolean converted, boolean truncateIfExists) throws IOException {
        Path tableArchivePath;
        if (newTableName == null || newTableName.equals((Object)"")) {
            newTableName = tableName;
        }
        FileSystem fileSys = tableBackupPath.getFileSystem(this.conf);
        HTableDescriptor tableDescriptor = null;
        Path tableSnapshotPath = RestoreServerUtil.getTableSnapshotPath(this.backupRootPath, tableName, this.backupId);
        if (fileSys.exists(tableSnapshotPath)) {
            if (this.snapshotMap.get(tableName) != null) {
                HBaseProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo(fileSys, tableSnapshotPath);
                SnapshotManifest manifest = SnapshotManifest.open(this.conf, fileSys, tableSnapshotPath, desc);
                tableDescriptor = manifest.getTableDescriptor();
            } else {
                tableDescriptor = this.getTableDesc(tableName);
                this.snapshotMap.put(tableName, this.getTableInfoPath(tableName));
            }
            if (tableDescriptor == null) {
                LOG.debug((Object)"Found no table descriptor in the snapshot dir, previous schema would be lost");
            }
        } else if (converted) {
            LOG.error((Object)"convert will be supported in a future jira");
        }
        if ((tableArchivePath = this.getTableArchivePath(tableName)) == null) {
            if (tableDescriptor == null) throw new IllegalStateException("Cannot restore hbase table because directory ' tableArchivePath is null.");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("find table descriptor but no archive dir for table " + tableName + ", will only create table"));
            }
            tableDescriptor.setName(newTableName);
            this.checkAndCreateTable(tableBackupPath, tableName, newTableName, null, tableDescriptor, truncateIfExists);
            return;
        }
        if (tableDescriptor == null) {
            tableDescriptor = new HTableDescriptor(newTableName);
        } else {
            tableDescriptor.setName(newTableName);
        }
        if (!converted) {
            try {
                ArrayList<Path> regionPathList = this.getRegionList(tableName);
                this.checkAndCreateTable(tableBackupPath, tableName, newTableName, regionPathList, tableDescriptor, truncateIfExists);
                if (tableArchivePath == null) return;
                Path tempTableArchivePath = this.checkLocalAndBackup(tableArchivePath);
                if (tempTableArchivePath.equals((Object)tableArchivePath)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("TableArchivePath for bulkload using existPath: " + tableArchivePath));
                    }
                } else {
                    regionPathList = this.getRegionList(tempTableArchivePath);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("TableArchivePath for bulkload using tempPath: " + tempTableArchivePath));
                    }
                }
                LoadIncrementalHFiles loader = this.createLoader(tempTableArchivePath, false);
                for (Path regionPath : regionPathList) {
                    String regionName = regionPath.toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Restoring HFiles from directory " + regionName));
                    }
                    String[] args = new String[]{regionName, newTableName.getNameAsString()};
                    loader.run(args);
                }
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot restore hbase table", e);
            }
        } else {
            LOG.debug((Object)"convert will be supported in a future jira");
        }
    }

    ArrayList<Path> getRegionList(Path tableArchivePath) throws FileNotFoundException, IOException {
        FileStatus[] children;
        ArrayList<Path> regionDirList = new ArrayList<Path>();
        for (FileStatus childStatus : children = this.fs.listStatus(tableArchivePath)) {
            Path child = childStatus.getPath();
            regionDirList.add(child);
        }
        return regionDirList;
    }

    int getNumberOfFilesInDir(Path regionPath) throws IOException {
        FileStatus[] tableDirContent;
        int result = 0;
        if (!this.fs.exists(regionPath) || !this.fs.getFileStatus(regionPath).isDirectory()) {
            throw new IllegalStateException("Cannot restore hbase table because directory '" + regionPath.toString() + "' is not a directory.");
        }
        for (FileStatus subDirStatus : tableDirContent = this.fs.listStatus(regionPath)) {
            FileStatus[] colFamilies;
            for (FileStatus colFamilyStatus : colFamilies = this.fs.listStatus(subDirStatus.getPath())) {
                FileStatus[] colFamilyContent = this.fs.listStatus(colFamilyStatus.getPath());
                result += colFamilyContent.length;
            }
        }
        return result;
    }

    int getMaxNumberOfFilesInSubDir(Path tableArchivePath) throws IOException {
        int result = 1;
        ArrayList<Path> regionPathList = this.getRegionList(tableArchivePath);
        if (regionPathList == null || regionPathList.size() == 0) {
            throw new IllegalStateException("Cannot restore hbase table because directory '" + tableArchivePath + "' is not a directory.");
        }
        for (Path regionPath : regionPathList) {
            result = Math.max(result, this.getNumberOfFilesInDir(regionPath));
        }
        return result;
    }

    private LoadIncrementalHFiles createLoader(Path tableArchivePath, boolean multipleTables) throws IOException {
        Integer milliSecInMin = 60000;
        Integer previousMillis = this.conf.getInt("hbase.rpc.timeout", 0);
        Integer numberOfFilesInDir = multipleTables ? this.getMaxNumberOfFilesInSubDir(tableArchivePath) : this.getNumberOfFilesInDir(tableArchivePath);
        Integer calculatedMillis = numberOfFilesInDir * milliSecInMin;
        Integer resultMillis = Math.max(calculatedMillis, previousMillis);
        if (resultMillis > previousMillis) {
            LOG.info((Object)("Setting configuration for restore with LoadIncrementalHFile: hbase.rpc.timeout to " + calculatedMillis / milliSecInMin + " minutes, to handle the number of files in backup " + tableArchivePath));
            this.conf.setInt("hbase.rpc.timeout", resultMillis.intValue());
        }
        this.conf.setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", Integer.MAX_VALUE);
        LoadIncrementalHFiles loader = null;
        try {
            loader = new LoadIncrementalHFiles(this.conf);
        }
        catch (Exception e1) {
            throw new IOException(e1);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[][] generateBoundaryKeys(ArrayList<Path> regionDirList) throws FileNotFoundException, IOException {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        byte[][] keys = null;
        for (Path regionDir : regionDirList) {
            FileStatus[] familyDirStatuses;
            LOG.debug((Object)("Parsing region dir: " + regionDir));
            Path hfofDir = regionDir;
            if (!this.fs.exists(hfofDir)) {
                LOG.warn((Object)("HFileOutputFormat dir " + hfofDir + " not found"));
            }
            if ((familyDirStatuses = this.fs.listStatus(hfofDir)) == null) {
                throw new IOException("No families found in " + hfofDir);
            }
            for (FileStatus stat : familyDirStatuses) {
                Path[] hfiles;
                if (!stat.isDirectory()) {
                    LOG.warn((Object)("Skipping non-directory " + stat.getPath()));
                    continue;
                }
                boolean isIgnore = false;
                String pathName = stat.getPath().getName();
                for (String ignore : this.ignoreDirs) {
                    if (!pathName.contains(ignore)) continue;
                    LOG.warn((Object)("Skipping non-family directory" + pathName));
                    isIgnore = true;
                    break;
                }
                if (isIgnore) continue;
                Path familyDir = stat.getPath();
                LOG.debug((Object)("Parsing family dir [" + familyDir.toString() + " in region [" + regionDir + "]"));
                if (familyDir.getName().startsWith("_") || familyDir.getName().startsWith(".")) continue;
                for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])this.fs.listStatus(familyDir))) {
                    if (hfile.getName().startsWith("_") || hfile.getName().startsWith(".") || StoreFileInfo.isReference(hfile.getName()) || HFileLink.isHFileLink(hfile.getName())) continue;
                    try (HFile.Reader reader = HFile.createReader(this.fs, hfile, new CacheConfig(this.conf), this.conf);){
                        reader.loadFileInfo();
                        byte[] first = reader.getFirstRowKey();
                        byte[] last = reader.getLastRowKey();
                        LOG.debug((Object)("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last)));
                        Integer value = map.containsKey(first) ? map.get(first) : 0;
                        map.put(first, value + 1);
                        value = map.containsKey(last) ? map.get(last) : 0;
                        map.put(last, value - 1);
                    }
                }
            }
        }
        keys = LoadIncrementalHFiles.inferBoundaries(map);
        return keys;
    }

    private void checkAndCreateTable(Path tableBackupPath, TableName tableName, TableName targetTableName, ArrayList<Path> regionDirList, HTableDescriptor htd, boolean truncateIfExists) throws IOException {
        HBaseAdmin hbadmin = null;
        Connection conn = null;
        try {
            conn = ConnectionFactory.createConnection((Configuration)this.conf);
            hbadmin = (HBaseAdmin)conn.getAdmin();
            boolean createNew = false;
            if (hbadmin.tableExists(targetTableName)) {
                if (truncateIfExists) {
                    LOG.info((Object)("Truncating exising target table '" + targetTableName + "', preserving region splits"));
                    hbadmin.disableTable(targetTableName);
                    hbadmin.truncateTable(targetTableName, true);
                } else {
                    LOG.info((Object)("Using exising target table '" + targetTableName + "'"));
                }
            } else {
                createNew = true;
            }
            if (createNew) {
                LOG.info((Object)("Creating target table '" + targetTableName + "'"));
                if (regionDirList == null || regionDirList.size() == 0) {
                    hbadmin.createTable(htd);
                    return;
                }
                byte[][] keys = this.generateBoundaryKeys(regionDirList);
                hbadmin.createTable(htd, keys);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (hbadmin != null) {
                hbadmin.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

