/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"coprocessor"})
@InterfaceStability.Evolving
public class CompactionRequest
implements Comparable<CompactionRequest> {
    static final Log LOG = LogFactory.getLog(CompactionRequest.class);
    private boolean isOffPeak = false;
    private DisplayCompactionType isMajor = DisplayCompactionType.MINOR;
    private int priority = Integer.MIN_VALUE;
    private Collection<StoreFile> filesToCompact;
    private long selectionTime = EnvironmentEdgeManager.currentTime();
    private Long timeInNanos = System.nanoTime();
    private String regionName = "";
    private String storeName = "";
    private long totalSize = -1L;
    private Boolean retainDeleteMarkers = null;

    public CompactionRequest() {
    }

    public CompactionRequest(Collection<StoreFile> files) {
        this();
        Preconditions.checkNotNull(files);
        this.filesToCompact = files;
        this.recalculateSize();
    }

    public void updateFiles(Collection<StoreFile> files) {
        this.filesToCompact = files;
    }

    public void beforeExecute() {
    }

    public void afterExecute() {
    }

    public CompactionRequest combineWith(CompactionRequest other) {
        this.filesToCompact = new ArrayList<StoreFile>(other.getFiles());
        this.isOffPeak = other.isOffPeak;
        this.isMajor = other.isMajor;
        this.priority = other.priority;
        this.selectionTime = other.selectionTime;
        this.timeInNanos = other.timeInNanos;
        this.regionName = other.regionName;
        this.storeName = other.storeName;
        this.totalSize = other.totalSize;
        this.recalculateSize();
        return this;
    }

    @Override
    public int compareTo(CompactionRequest request) {
        if (this.equals(request)) {
            return 0;
        }
        int compareVal = this.priority - request.priority;
        if (compareVal != 0) {
            return compareVal;
        }
        compareVal = this.timeInNanos.compareTo(request.timeInNanos);
        if (compareVal != 0) {
            return compareVal;
        }
        return this.hashCode() - request.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public Collection<StoreFile> getFiles() {
        return this.filesToCompact;
    }

    public void setDescription(String regionName, String storeName) {
        this.regionName = regionName;
        this.storeName = storeName;
    }

    public long getSize() {
        return this.totalSize;
    }

    public boolean isAllFiles() {
        return this.isMajor == DisplayCompactionType.MAJOR || this.isMajor == DisplayCompactionType.ALL_FILES;
    }

    public boolean isMajor() {
        return this.isMajor == DisplayCompactionType.MAJOR;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public boolean isOffPeak() {
        return this.isOffPeak;
    }

    public void setOffPeak(boolean value) {
        this.isOffPeak = value;
    }

    public long getSelectionTime() {
        return this.selectionTime;
    }

    public void setIsMajor(boolean isMajor, boolean isAllFiles) {
        assert (isAllFiles || !isMajor);
        this.isMajor = !isAllFiles ? DisplayCompactionType.MINOR : (isMajor ? DisplayCompactionType.MAJOR : DisplayCompactionType.ALL_FILES);
    }

    public void forceRetainDeleteMarkers() {
        this.retainDeleteMarkers = Boolean.TRUE;
    }

    public boolean isRetainDeleteMarkers() {
        return this.retainDeleteMarkers != null ? this.retainDeleteMarkers : !this.isAllFiles();
    }

    public String toString() {
        String fsList = Joiner.on((String)", ").join((Iterable)Collections2.transform((Collection)Collections2.filter(this.getFiles(), (Predicate)new Predicate<StoreFile>(){

            public boolean apply(StoreFile sf) {
                return sf.getReader() != null;
            }
        }), (Function)new Function<StoreFile, String>(){

            public String apply(StoreFile sf) {
                return StringUtils.humanReadableInt((long)(sf.getReader() == null ? 0L : sf.getReader().length()));
            }
        }));
        return "regionName=" + this.regionName + ", storeName=" + this.storeName + ", fileCount=" + this.getFiles().size() + ", fileSize=" + StringUtils.humanReadableInt((long)this.totalSize) + (fsList.isEmpty() ? "" : " (" + fsList + ")") + ", priority=" + this.priority + ", time=" + this.timeInNanos;
    }

    private void recalculateSize() {
        long sz = 0L;
        for (StoreFile sf : this.filesToCompact) {
            StoreFile.Reader r = sf.getReader();
            sz += r == null ? 0L : r.length();
        }
        this.totalSize = sz;
    }

    private static enum DisplayCompactionType {
        MINOR,
        ALL_FILES,
        MAJOR;

    }
}

