/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static final String META_FOLDER_NAME = "metastore";
    public static final String ELEMENT_TYPE_FILE_NAME = ".type.xml";

    public static String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    public static String getNamespaceFolder(String rootFolder, String namespace) {
        return rootFolder + File.separator + namespace;
    }

    public static String getElementTypeFolder(String rootFolder, String namespace, String elementTypeId) {
        return XmlUtil.getNamespaceFolder(rootFolder, namespace) + File.separator + elementTypeId;
    }

    public static String getElementTypeFile(String rootFolder, String namespace, String elementTypeId) {
        return XmlUtil.getElementTypeFolder(rootFolder, namespace, elementTypeId) + File.separator + ELEMENT_TYPE_FILE_NAME;
    }

    public static String getElementFile(String rootFolder, String namespace, String elementTypeId, String elementId) {
        return XmlUtil.getElementTypeFolder(rootFolder, namespace, elementTypeId) + File.separator + elementId + ".xml";
    }

    public static DocumentBuilderFactory createSafeDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory;
    }
}

