/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.JVMReuseManager;

public class JVMReuseImpl {
    private static Log LOG = LogFactory.getLog(JVMReuseImpl.class);

    public void cleanupStaticData() {
        String className = null;
        String msg = null;
        List<Method> staticCleanupMethods = JVMReuseManager.getInstance().getStaticDataCleanupMethods();
        for (Method m : staticCleanupMethods) {
            try {
                className = m.getDeclaringClass() == null ? "anonymous" : m.getDeclaringClass().getName();
                msg = "Invoking method " + m.getName() + " in class " + className + " for static data cleanup";
                if (className.startsWith("org.apache.pig")) {
                    LOG.debug((Object)msg);
                } else {
                    LOG.info((Object)msg);
                }
                m.invoke(null, new Object[0]);
                msg = null;
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while calling static methods:" + this.getMethodNames() + ". " + msg), (Throwable)e);
                throw new RuntimeException("Error while " + msg, e);
            }
        }
    }

    private String getMethodNames() {
        StringBuilder sb = new StringBuilder();
        for (Method m : JVMReuseManager.getInstance().getStaticDataCleanupMethods()) {
            if (m == null) {
                sb.append("null,");
                continue;
            }
            sb.append(m.getDeclaringClass() == null ? "anonymous" : m.getDeclaringClass().getName());
            sb.append(".").append(m.getName()).append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

