/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.TezOperDependencyParallelismEstimator;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigProcessor;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;

public class TezOperator
extends Operator<TezOpPlanVisitor> {
    private static final long serialVersionUID = 1L;
    public transient PhysicalPlan plan;
    public Map<OperatorKey, TezEdgeDescriptor> outEdges;
    public Map<OperatorKey, TezEdgeDescriptor> inEdges;
    public Set<String> UDFs;
    public Set<PhysicalOperator> scalars;
    private AtomicInteger requestedParallelism = new AtomicInteger(-1);
    private int estimatedParallelism = -1;
    private boolean dontEstimateParallelism = false;
    private boolean overrideIntermediateParallelism = false;
    private int vertexParallelism = -1;
    private boolean splitter;
    private OperatorKey splitParent = null;
    boolean closed = false;
    boolean segmentBelow = false;
    boolean[] sortOrder;
    private boolean combineSmallSplits = true;
    private TezOperator sampleOperator = null;
    private TezOperator sortOperator = null;
    private boolean needEstimateParallelism = false;
    private boolean useSecondaryKey = false;
    private List<String> crossKeys = null;
    private boolean useMRMapSettings = false;
    private boolean useGraceParallelism = false;
    private double parallelismFactor = -1.0;
    private LinkedList<POStore> stores = null;
    BitSet feature = new BitSet();
    private List<OperatorKey> vertexGroupMembers;
    private transient VertexGroupInfo vertexGroupInfo;
    private Map<OperatorKey, OperatorKey> vertexGroupStores = null;
    private LoaderInfo loaderInfo = new LoaderInfo();

    public TezOperator(OperatorKey k) {
        super(k);
        this.plan = new PhysicalPlan();
        this.outEdges = Maps.newHashMap();
        this.inEdges = Maps.newHashMap();
        this.UDFs = Sets.newHashSet();
        this.scalars = Sets.newHashSet();
    }

    public String getProcessorName() {
        return PigProcessor.class.getName();
    }

    @Override
    public void visit(TezOpPlanVisitor v) throws VisitorException {
        v.visitTezOp(this);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism.get();
    }

    public void setRequestedParallelism(int requestedParallelism) {
        this.requestedParallelism.set(requestedParallelism);
    }

    public void setRequestedParallelismByReference(TezOperator oper) {
        this.requestedParallelism = oper.requestedParallelism;
    }

    public int getEstimatedParallelism() {
        return this.estimatedParallelism;
    }

    public void setEstimatedParallelism(int estimatedParallelism) {
        this.estimatedParallelism = estimatedParallelism;
    }

    public int getEffectiveParallelism(int defaultParallelism) {
        return this.getEstimatedParallelism() == -1 ? (this.getRequestedParallelism() == -1 ? defaultParallelism : this.getRequestedParallelism()) : this.getEstimatedParallelism();
    }

    public boolean isDontEstimateParallelism() {
        return this.dontEstimateParallelism;
    }

    public void setDontEstimateParallelism(boolean dontEstimateParallelism) {
        this.dontEstimateParallelism = dontEstimateParallelism;
    }

    public boolean isOverrideIntermediateParallelism() {
        return this.overrideIntermediateParallelism;
    }

    public void setOverrideIntermediateParallelism(boolean overrideIntermediateParallelism) {
        this.overrideIntermediateParallelism = overrideIntermediateParallelism;
    }

    public OperatorKey getSplitParent() {
        return this.splitParent;
    }

    public void setSplitParent(OperatorKey splitParent) {
        this.splitParent = splitParent;
    }

    public void setSplitter(boolean spl) {
        this.splitter = spl;
    }

    public boolean isSplitter() {
        return this.splitter;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isIndexer() {
        return this.feature.get(OPER_FEATURE.INDEXER.ordinal());
    }

    public void markIndexer() {
        this.feature.set(OPER_FEATURE.INDEXER.ordinal());
    }

    public boolean isSampler() {
        return this.feature.get(OPER_FEATURE.SAMPLER.ordinal());
    }

    public void markSampler() {
        this.feature.set(OPER_FEATURE.SAMPLER.ordinal());
    }

    public boolean isSampleAggregation() {
        return this.feature.get(OPER_FEATURE.SAMPLE_AGGREGATOR.ordinal());
    }

    public void markSampleAggregation() {
        this.feature.set(OPER_FEATURE.SAMPLE_AGGREGATOR.ordinal());
    }

    public boolean isSampleBasedPartitioner() {
        return this.feature.get(OPER_FEATURE.SAMPLE_BASED_PARTITIONER.ordinal());
    }

    public void markSampleBasedPartitioner() {
        this.feature.set(OPER_FEATURE.SAMPLE_BASED_PARTITIONER.ordinal());
    }

    public boolean isGlobalSort() {
        return this.feature.get(OPER_FEATURE.GLOBAL_SORT.ordinal());
    }

    public void markGlobalSort() {
        this.feature.set(OPER_FEATURE.GLOBAL_SORT.ordinal());
    }

    public boolean isGroupBy() {
        return this.feature.get(OPER_FEATURE.GROUPBY.ordinal());
    }

    public void markGroupBy() {
        this.feature.set(OPER_FEATURE.GROUPBY.ordinal());
    }

    public boolean isCogroup() {
        return this.feature.get(OPER_FEATURE.COGROUP.ordinal());
    }

    public void markCogroup() {
        this.feature.set(OPER_FEATURE.COGROUP.ordinal());
    }

    public boolean isRegularJoin() {
        return this.feature.get(OPER_FEATURE.HASHJOIN.ordinal());
    }

    public void markRegularJoin() {
        this.feature.set(OPER_FEATURE.HASHJOIN.ordinal());
    }

    public boolean isSkewedJoin() {
        return this.feature.get(OPER_FEATURE.SKEWEDJOIN.ordinal());
    }

    public void markSkewedJoin() {
        this.feature.set(OPER_FEATURE.SKEWEDJOIN.ordinal());
    }

    public boolean isLimit() {
        return this.feature.get(OPER_FEATURE.LIMIT.ordinal());
    }

    public void markLimit() {
        this.feature.set(OPER_FEATURE.LIMIT.ordinal());
    }

    public boolean isLimitAfterSort() {
        return this.feature.get(OPER_FEATURE.LIMIT_AFTER_SORT.ordinal());
    }

    public void markLimitAfterSort() {
        this.feature.set(OPER_FEATURE.LIMIT_AFTER_SORT.ordinal());
    }

    public boolean isUnion() {
        return this.feature.get(OPER_FEATURE.UNION.ordinal());
    }

    public void markUnion() {
        this.feature.set(OPER_FEATURE.UNION.ordinal());
    }

    public boolean isNative() {
        return this.feature.get(OPER_FEATURE.NATIVE.ordinal());
    }

    public void markNative() {
        this.feature.set(OPER_FEATURE.NATIVE.ordinal());
    }

    public void copyFeatures(TezOperator copyFrom, List<OPER_FEATURE> excludeFeatures) {
        for (OPER_FEATURE opf : OPER_FEATURE.values()) {
            if (excludeFeatures != null && excludeFeatures.contains((Object)opf) || !copyFrom.feature.get(opf.ordinal())) continue;
            this.feature.set(opf.ordinal());
        }
    }

    public void setNeedEstimatedQuantile(boolean needEstimateParallelism) {
        this.needEstimateParallelism = needEstimateParallelism;
    }

    public boolean isNeedEstimateParallelism() {
        return this.needEstimateParallelism;
    }

    public boolean isUseSecondaryKey() {
        return this.useSecondaryKey;
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
    }

    public List<OperatorKey> getUnionMembers() {
        return this.vertexGroupMembers;
    }

    public List<OperatorKey> getVertexGroupMembers() {
        return this.vertexGroupMembers;
    }

    public void addUnionPredecessor(OperatorKey unionPredecessor) {
        if (this.vertexGroupMembers == null) {
            this.vertexGroupMembers = new ArrayList<OperatorKey>();
        }
        this.vertexGroupMembers.add(unionPredecessor);
    }

    public void setVertexGroupMembers(List<OperatorKey> vertexGroupMembers) {
        this.vertexGroupMembers = vertexGroupMembers;
    }

    public boolean isVertexGroup() {
        return this.vertexGroupInfo != null;
    }

    public VertexGroupInfo getVertexGroupInfo() {
        return this.vertexGroupInfo;
    }

    public void setVertexGroupInfo(VertexGroupInfo vertexGroup) {
        this.vertexGroupInfo = vertexGroup;
    }

    public void addVertexGroupStore(OperatorKey storeKey, OperatorKey vertexGroupKey) {
        if (this.vertexGroupStores == null) {
            this.vertexGroupStores = new HashMap<OperatorKey, OperatorKey>();
        }
        this.vertexGroupStores.put(storeKey, vertexGroupKey);
    }

    public Map<OperatorKey, OperatorKey> getVertexGroupStores() {
        return this.vertexGroupStores;
    }

    @Override
    public String name() {
        String udfStr = this.getUDFsAsStr();
        StringBuilder sb = new StringBuilder("Tez(" + this.requestedParallelism + (udfStr.equals("") ? "" : ",") + udfStr + ")" + " - " + this.mKey.toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name() + ":\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.plan != null && !this.plan.isEmpty()) {
            this.plan.explain(baos);
            String mp = new String(baos.toByteArray());
            sb.append(this.shiftStringByTabs(mp, "|   "));
        } else {
            sb.append("Plan Empty");
        }
        return sb.toString();
    }

    private String getUDFsAsStr() {
        StringBuilder sb = new StringBuilder();
        if (this.UDFs != null && this.UDFs.size() > 0) {
            for (String str : this.UDFs) {
                sb.append(str.substring(str.lastIndexOf(46) + 1));
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String shiftStringByTabs(String DFStr, String tab) {
        StringBuilder sb = new StringBuilder();
        String[] spl = DFStr.split("\n");
        for (int i = 0; i < spl.length; ++i) {
            sb.append(tab);
            sb.append(spl[i]);
            sb.append("\n");
        }
        sb.delete(sb.length() - "\n".length(), sb.length());
        return sb.toString();
    }

    public boolean needSegmentBelow() {
        return this.segmentBelow;
    }

    public void setSortOrder(boolean[] sortOrder) {
        if (null == sortOrder) {
            return;
        }
        this.sortOrder = new boolean[sortOrder.length];
        for (int i = 0; i < sortOrder.length; ++i) {
            this.sortOrder[i] = sortOrder[i];
        }
    }

    public boolean[] getSortOrder() {
        return this.sortOrder;
    }

    public TezOperator getSampleOperator() {
        return this.sampleOperator;
    }

    public void setSampleOperator(TezOperator sampleOperator) {
        this.sampleOperator = sampleOperator;
    }

    public TezOperator getSortOperator() {
        return this.sortOperator;
    }

    public void setSortOperator(TezOperator sortOperator) {
        this.sortOperator = sortOperator;
    }

    protected void noCombineSmallSplits() {
        this.combineSmallSplits = false;
    }

    public boolean combineSmallSplits() {
        return this.combineSmallSplits;
    }

    public void addCrossKey(String key) {
        if (this.crossKeys == null) {
            this.crossKeys = new ArrayList<String>();
        }
        this.crossKeys.add(key);
    }

    public List<String> getCrossKeys() {
        return this.crossKeys;
    }

    public boolean isUseMRMapSettings() {
        return this.useMRMapSettings;
    }

    public void setUseMRMapSettings(boolean useMRMapSettings) {
        this.useMRMapSettings = useMRMapSettings;
    }

    public int getVertexParallelism() {
        return this.vertexParallelism;
    }

    public void setVertexParallelism(int vertexParallelism) {
        this.vertexParallelism = vertexParallelism;
    }

    public LoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    public void setUseGraceParallelism(boolean useGraceParallelism) {
        this.useGraceParallelism = useGraceParallelism;
    }

    public boolean isUseGraceParallelism() {
        return this.useGraceParallelism;
    }

    public double getParallelismFactor() throws VisitorException {
        if (this.parallelismFactor == -1.0) {
            TezOperDependencyParallelismEstimator.TezParallelismFactorVisitor parallelismFactorVisitor = new TezOperDependencyParallelismEstimator.TezParallelismFactorVisitor(this.plan, this.getOperatorKey().toString());
            parallelismFactorVisitor.visit();
            this.parallelismFactor = parallelismFactorVisitor.getFactor();
        }
        return this.parallelismFactor;
    }

    public LinkedList<POStore> getStores() throws VisitorException {
        if (this.stores == null) {
            this.stores = PlanHelper.getPhysicalOperators(this.plan, POStore.class);
        }
        return this.stores;
    }

    public static class VertexGroupInfo {
        private List<OperatorKey> inputKeys;
        private String outputKey;
        private POStore store;
        private OutputDescriptor storeOutDescriptor;
        private VertexGroup vertexGroup;
        private FileSpec sFile;

        public VertexGroupInfo() {
        }

        public VertexGroupInfo(POStore store) {
            this.store = store;
        }

        public List<OperatorKey> getInputs() {
            return this.inputKeys;
        }

        public void addInput(OperatorKey input) {
            if (this.inputKeys == null) {
                this.inputKeys = new ArrayList<OperatorKey>();
            }
            this.inputKeys.add(input);
        }

        public boolean removeInput(OperatorKey input) {
            return this.inputKeys.remove(input);
        }

        public String getOutput() {
            return this.outputKey;
        }

        public void setOutput(String output) {
            this.outputKey = output;
        }

        public POStore getStore() {
            return this.store;
        }

        public OutputDescriptor getStoreOutputDescriptor() {
            return this.storeOutDescriptor;
        }

        public void setStoreOutputDescriptor(OutputDescriptor storeOutDescriptor) {
            this.storeOutDescriptor = storeOutDescriptor;
        }

        public VertexGroup getVertexGroup() {
            return this.vertexGroup;
        }

        public void setVertexGroup(VertexGroup vertexGroup) {
            this.vertexGroup = vertexGroup;
        }

        public void setSFile(FileSpec sFile) {
            this.sFile = sFile;
        }

        public FileSpec getSFile() {
            return this.sFile;
        }
    }

    public static class LoaderInfo
    implements Serializable {
        private List<POLoad> loads = null;
        private ArrayList<FileSpec> inp = new ArrayList();
        private ArrayList<String> inpSignatureLists = new ArrayList();
        private ArrayList<Long> inpLimits = new ArrayList();
        private transient InputSplitInfo inputSplitInfo = null;

        public List<POLoad> getLoads() {
            return this.loads;
        }

        public void setLoads(List<POLoad> loads) {
            this.loads = loads;
        }

        public ArrayList<FileSpec> getInp() {
            return this.inp;
        }

        public void setInp(ArrayList<FileSpec> inp) {
            this.inp = inp;
        }

        public ArrayList<String> getInpSignatureLists() {
            return this.inpSignatureLists;
        }

        public void setInpSignatureLists(ArrayList<String> inpSignatureLists) {
            this.inpSignatureLists = inpSignatureLists;
        }

        public ArrayList<Long> getInpLimits() {
            return this.inpLimits;
        }

        public void setInpLimits(ArrayList<Long> inpLimits) {
            this.inpLimits = inpLimits;
        }

        public InputSplitInfo getInputSplitInfo() {
            return this.inputSplitInfo;
        }

        public void setInputSplitInfo(InputSplitInfo inputSplitInfo) {
            this.inputSplitInfo = inputSplitInfo;
        }
    }

    public static enum OPER_FEATURE {
        INDEXER,
        SAMPLER,
        SAMPLE_AGGREGATOR,
        SAMPLE_BASED_PARTITIONER,
        GLOBAL_SORT,
        GROUPBY,
        COGROUP,
        HASHJOIN,
        SKEWEDJOIN,
        LIMIT,
        LIMIT_AFTER_SORT,
        UNION,
        NATIVE;

    }
}

