/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.pig.backend.hadoop.executionengine.tez.TezResourceManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerUDFCollector;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;

public class TezPlanContainer
extends OperatorPlan<TezPlanContainerNode> {
    private static final long serialVersionUID = 1L;
    private PigContext pigContext;
    private String jobName;
    private long dagId = 0L;
    private static long scopeId = 0L;

    public TezPlanContainer(PigContext pigContext) {
        this.pigContext = pigContext;
        this.jobName = pigContext.getProperties().getProperty("jobName", "pig");
    }

    public Map<String, LocalResource> getLocalResources() throws Exception {
        HashSet<URI> jarLists = new HashSet<URI>();
        for (String string : JarManager.getDefaultJars()) {
            jarLists.add(new File(string).toURI());
        }
        for (URL uRL : this.pigContext.extraJars) {
            jarLists.add(uRL.toURI());
        }
        for (String string : this.pigContext.scriptJars) {
            jarLists.add(new File(string).toURI());
        }
        for (Map.Entry entry : this.pigContext.getScriptFiles().entrySet()) {
            if (!((String)entry.getKey()).endsWith(".groovy")) continue;
            jarLists.add(((File)entry.getValue()).toURI());
        }
        TezPlanContainerUDFCollector tezPlanContainerUDFCollector = new TezPlanContainerUDFCollector(this);
        tezPlanContainerUDFCollector.visit();
        Set<String> set = tezPlanContainerUDFCollector.getUdfs();
        for (String func : set) {
            String jarName;
            Class clazz = this.pigContext.getClassForAlias(func);
            if (clazz == null || (jarName = JarManager.findContainingJar(clazz)) == null) continue;
            URI jarUri = new File(jarName).toURI();
            jarLists.add(jarUri);
        }
        File scriptUDFJarFile = JarManager.createPigScriptUDFJar(this.pigContext);
        if (scriptUDFJarFile != null) {
            jarLists.add(scriptUDFJarFile.toURI());
        }
        return TezResourceManager.getInstance().addTezResources(jarLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TezPlanContainerNode getNextPlan(List<TezOperPlan> processedPlans) {
        TezPlanContainer tezPlanContainer = this;
        synchronized (tezPlanContainer) {
            while (this.getRoots() != null) {
                if (this.getRoots().isEmpty()) return null;
                TezPlanContainerNode currentPlan = null;
                for (TezPlanContainerNode plan : this.getRoots()) {
                    if (processedPlans.contains(plan.getTezOperPlan())) continue;
                    currentPlan = plan;
                    break;
                }
                if (currentPlan != null) {
                    return currentPlan;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            return null;
        }
    }

    public void addPlan(TezOperPlan plan) throws PlanException {
        TezPlanContainerNode node = new TezPlanContainerNode(this.generateNodeOperatorKey(), plan);
        this.add(node);
        this.split(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlan(TezOperPlan plan, boolean succ) {
        TezPlanContainerNode tezPlanContainerNode = new TezPlanContainerNode(this.generateNodeOperatorKey(), plan);
        TezPlanContainer tezPlanContainer = this;
        synchronized (tezPlanContainer) {
            if (succ) {
                this.remove(tezPlanContainerNode);
            } else {
                this.trimBelow(tezPlanContainerNode);
                this.remove(tezPlanContainerNode);
            }
            this.notify();
        }
    }

    public void split(TezPlanContainerNode planNode) throws PlanException {
        TezOperPlan tezOperPlan = planNode.getTezOperPlan();
        TezOperator operToSegment = null;
        ArrayList<TezOperator> succs = new ArrayList<TezOperator>();
        for (TezOperator tezOper : tezOperPlan) {
            if (!tezOper.needSegmentBelow() || tezOperPlan.getSuccessors(tezOper) == null) continue;
            operToSegment = tezOper;
            succs.addAll(tezOperPlan.getSuccessors(tezOper));
            break;
        }
        if (operToSegment != null) {
            for (TezOperator succ : succs) {
                tezOperPlan.disconnect(operToSegment, succ);
                TezOperPlan newOperPlan = new TezOperPlan();
                ArrayList<TezPlanContainerNode> containerSuccs = new ArrayList<TezPlanContainerNode>();
                if (this.getSuccessors(planNode) != null) {
                    containerSuccs.addAll(this.getSuccessors(planNode));
                }
                tezOperPlan.moveTree(succ, newOperPlan);
                TezPlanContainerNode newPlanNode = new TezPlanContainerNode(this.generateNodeOperatorKey(), newOperPlan);
                this.add(newPlanNode);
                for (TezPlanContainerNode containerNodeSucc : containerSuccs) {
                    this.disconnect(planNode, containerNodeSucc);
                    this.connect(newPlanNode, containerNodeSucc);
                }
                this.connect(planNode, newPlanNode);
                this.split(newPlanNode);
            }
            this.split(planNode);
        }
    }

    private synchronized OperatorKey generateNodeOperatorKey() {
        OperatorKey opKey = new OperatorKey(this.jobName + "-" + this.dagId + "_scope", scopeId);
        ++scopeId;
        ++this.dagId;
        return opKey;
    }

    public static void resetScope() {
        scopeId = 0L;
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        TezPlanContainerPrinter printer = new TezPlanContainerPrinter(ps, this);
        printer.setVerbose(true);
        try {
            printer.visit();
        }
        catch (VisitorException e) {
            throw new RuntimeException(e);
        }
        return baos.toString();
    }
}

