/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.PrintStream;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPrinter;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class TezPlanContainerPrinter
extends TezPlanContainerVisitor {
    private PrintStream mStream = null;
    private boolean isVerbose = true;

    public TezPlanContainerPrinter(PrintStream ps, TezPlanContainer planContainer) {
        super(planContainer, (PlanWalker<TezPlanContainerNode, TezPlanContainer>)new DependencyOrderWalker<TezPlanContainerNode, TezPlanContainer>(planContainer));
        this.mStream = ps;
        this.mStream.println("#--------------------------------------------------");
        this.mStream.println("# There are " + planContainer.size() + " DAGs in the session");
        this.mStream.println("#--------------------------------------------------");
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public void visitTezPlanContainerNode(TezPlanContainerNode tezPlanContainerNode) throws VisitorException {
        this.mStream.println("#--------------------------------------------------");
        this.mStream.println("# TEZ DAG plan: " + tezPlanContainerNode.getOperatorKey());
        this.mStream.println("#--------------------------------------------------");
        TezPrinter.TezGraphPrinter graphPrinter = new TezPrinter.TezGraphPrinter(tezPlanContainerNode.getTezOperPlan());
        graphPrinter.visit();
        this.mStream.print(graphPrinter.toString());
        TezPrinter printer = new TezPrinter(this.mStream, tezPlanContainerNode.getTezOperPlan());
        printer.setVerbose(this.isVerbose);
        printer.visit();
    }
}

