/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class PORankTez
extends PORank
implements TezInput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(PORankTez.class);
    private String tuplesInputKey;
    private String statsInputKey;
    private transient boolean isInputCached;
    private transient KeyValueReader reader;
    private transient Map<Integer, Long> counterOffsets;
    private transient Configuration conf;
    private transient boolean finished = false;

    public PORankTez(PORank copy) {
        super(copy);
    }

    public void setTuplesInputKey(String tuplesInputKey) {
        this.tuplesInputKey = tuplesInputKey;
    }

    public void setStatsInputKey(String statsInputKey) {
        this.statsInputKey = statsInputKey;
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.tuplesInputKey, this.statsInputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.tuplesInputKey)) {
            this.tuplesInputKey = newInputKey;
        } else if (oldInputKey.equals(this.statsInputKey)) {
            this.statsInputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
        String cacheKey = "rankstats-" + this.getOperatorKey().toString();
        Object cacheValue = ObjectCache.getInstance().retrieve(cacheKey);
        if (cacheValue != null) {
            this.isInputCached = true;
            inputsToSkip.add(this.statsInputKey);
        }
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        LogicalInput input = inputs.get(this.tuplesInputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.tuplesInputKey + " is missing");
        }
        try {
            this.reader = (KeyValueReader)input.getReader();
            LOG.info((Object)("Attached input from vertex " + this.tuplesInputKey + " : input=" + input + ", reader=" + this.reader));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
        String cacheKey = "rankstats-" + this.getOperatorKey().toString();
        if (this.isInputCached) {
            this.counterOffsets = (Map)ObjectCache.getInstance().retrieve(cacheKey);
            LOG.info((Object)("Found counter stats for PORankTez in Tez cache. cachekey=" + cacheKey));
            return;
        }
        input = inputs.get(this.statsInputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.statsInputKey + " is missing");
        }
        try {
            KeyValueReader reader = (KeyValueReader)input.getReader();
            LOG.info((Object)("Attached input from vertex " + this.statsInputKey + " : input=" + input + ", reader=" + reader));
            reader.next();
            Map counterOffsetsTemp = (Map)((Tuple)reader.getCurrentValue()).get(0);
            this.counterOffsets = new HashMap<Integer, Long>(counterOffsetsTemp.size(), 1.0f);
            for (Map.Entry entry : counterOffsetsTemp.entrySet()) {
                this.counterOffsets.put(Integer.valueOf((String)entry.getKey()), (Long)entry.getValue());
            }
            ObjectCache.getInstance().cache(cacheKey, this.counterOffsets);
            LOG.info((Object)("Cached PORankTez counter stats in Tez ObjectRegistry with vertex scope. cachekey=" + cacheKey));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (this.finished) {
            return RESULT_EOP;
        }
        Result inp = null;
        try {
            if (this.reader.next()) {
                inp = new Result(0, this.reader.getCurrentValue());
                return this.addRank(inp);
            }
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
        if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
            this.parentPlan.endOfAllInput = true;
        }
        this.finished = true;
        return RESULT_EOP;
    }

    @Override
    protected Long getRankCounterOffset(Integer taskId) {
        if (this.illustrator != null) {
            return 0L;
        }
        return this.counterOffsets.get(taskId);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        super.visit(v);
        v.visit(this);
    }

    @Override
    public String name() {
        return "PORankTez - " + this.mKey.toString() + "\t<-\t " + this.tuplesInputKey + "," + this.statsInputKey;
    }
}

