/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class POValueInputTez
extends PhysicalOperator
implements TezInput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POValueInputTez.class);
    private String inputKey;
    private transient boolean finished = false;
    private transient Configuration conf;
    private transient KeyValueReader reader;
    private transient KeyValuesReader shuffleReader;
    private transient boolean shuffleInput;
    private transient boolean hasNext;
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();

    public POValueInputTez(OperatorKey k) {
        super(k);
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        LogicalInput input = inputs.get(this.inputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            Reader r = input.getReader();
            if (r instanceof KeyValueReader) {
                this.reader = (KeyValueReader)r;
            } else {
                this.shuffleInput = true;
                this.shuffleReader = (KeyValuesReader)r;
                this.hasNext = this.shuffleReader.next();
            }
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + input + ", reader=" + r));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            if (this.finished) {
                return RESULT_EOP;
            }
            if (this.shuffleInput) {
                while (this.hasNext) {
                    if (this.shuffleReader.getCurrentValues().iterator().hasNext()) {
                        Tuple origTuple = (Tuple)this.shuffleReader.getCurrentValues().iterator().next();
                        Tuple copy = mTupleFactory.newTuple(origTuple.getAll());
                        return new Result(0, copy);
                    }
                    this.hasNext = this.shuffleReader.next();
                }
            } else if (this.reader.next()) {
                Tuple origTuple = (Tuple)this.reader.getCurrentValue();
                Tuple copy = mTupleFactory.newTuple(origTuple.getAll());
                return new Result(0, copy);
            }
            this.finished = true;
            if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
                this.parentPlan.endOfAllInput = true;
            }
            return RESULT_EOP;
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return "POValueInputTez - " + this.mKey.toString() + "\t<-\t " + this.inputKey;
    }
}

