/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.Algebraic;
import org.apache.pig.builtin.BuildBloomBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BuildBloom
extends BuildBloomBase<DataByteArray>
implements Algebraic {
    public BuildBloom(String hashType, String mode, String vectorSize, String nbHash) {
        super(hashType, mode, vectorSize, nbHash);
    }

    public BuildBloom(String hashType, String numElements, String desiredFalsePositive) {
        super(hashType, numElements, desiredFalsePositive);
    }

    @Override
    public DataByteArray exec(Tuple input) throws IOException {
        throw new IOException("This must be used with algebraic!");
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 50));
    }

    public static class Final
    extends BuildBloomBase<DataByteArray> {
        public Final() {
        }

        public Final(String hashType, String mode, String vectorSize, String nbHash) {
            super(hashType, mode, vectorSize, nbHash);
        }

        public Final(String hashType, String numElements, String desiredFalsePositive) {
            super(hashType, numElements, desiredFalsePositive);
        }

        @Override
        public DataByteArray exec(Tuple input) throws IOException {
            return this.bloomOr(input);
        }
    }

    public static class Intermediate
    extends BuildBloomBase<Tuple> {
        public Intermediate() {
        }

        public Intermediate(String hashType, String mode, String vectorSize, String nbHash) {
            super(hashType, mode, vectorSize, nbHash);
        }

        public Intermediate(String hashType, String numElements, String desiredFalsePositive) {
            super(hashType, numElements, desiredFalsePositive);
        }

        @Override
        public Tuple exec(Tuple input) throws IOException {
            return TupleFactory.getInstance().newTuple(this.bloomOr(input));
        }
    }

    public static class Initial
    extends BuildBloomBase<Tuple> {
        public Initial() {
        }

        public Initial(String hashType, String mode, String vectorSize, String nbHash) {
            super(hashType, mode, vectorSize, nbHash);
        }

        public Initial(String hashType, String numElements, String desiredFalsePositive) {
            super(hashType, numElements, desiredFalsePositive);
        }

        @Override
        public Tuple exec(Tuple input) throws IOException {
            if (input == null || input.size() == 0) {
                return null;
            }
            DataBag values = (DataBag)input.get(0);
            Iterator<Tuple> it = values.iterator();
            Tuple t = it.next();
            byte[] b = t.size() == 1 ? DataType.toBytes(t.get(0)) : DataType.toBytes(t, (byte)110);
            Key k = new Key(b);
            this.filter = new BloomFilter(this.vSize, this.numHash, this.hType);
            this.filter.add(k);
            return TupleFactory.getInstance().newTuple(this.bloomOut());
        }
    }
}

