/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.pig.ResourceSchema;
import org.apache.pig.builtin.HiveUDFBase;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.hive.HiveUtils;

public class HiveUDTF
extends HiveUDFBase {
    private boolean inited = false;
    private GenericUDTF udtf;
    private boolean endOfAllInput = false;
    SchemaInfo schemaInfo = new SchemaInfo();
    HiveUDFBase.ConstantObjectInspectInfo constantsInfo;
    private static BagFactory bf = BagFactory.getInstance();
    private HiveUDTFCollector collector = null;

    public HiveUDTF(String funcName) throws InstantiationException, IllegalAccessException, IOException {
        Class hiveUDTFClass = HiveUDTF.resolveFunc(funcName);
        if (!GenericUDTF.class.isAssignableFrom(hiveUDTFClass)) {
            throw new IOException(HiveUDTF.getErrorMessage(hiveUDTFClass));
        }
        this.udtf = (GenericUDTF)hiveUDTFClass.newInstance();
    }

    public HiveUDTF(String funcName, String params) throws InstantiationException, IllegalAccessException, IOException {
        this(funcName);
        this.constantsInfo = HiveUDFBase.ConstantObjectInspectInfo.parse(params);
    }

    @Override
    public Object exec(Tuple input) throws IOException {
        if (!this.inited) {
            this.udtf.configure(HiveUDTF.instantiateMapredContext());
            this.schemaInfo.init(this.getInputSchema(), this.udtf, this.constantsInfo);
            this.inited = true;
        }
        if (this.collector == null) {
            this.collector = new HiveUDTFCollector();
            this.udtf.setCollector((Collector)this.collector);
        } else {
            this.collector.init();
        }
        try {
            if (!this.endOfAllInput) {
                this.udtf.process(input.getAll().toArray());
            } else {
                this.udtf.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.collector.getBag();
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (!this.inited) {
                this.schemaInfo.init(this.getInputSchema(), this.udtf, this.constantsInfo);
                this.inited = true;
            }
            ResourceSchema.ResourceFieldSchema rfs = HiveUtils.getResourceFieldSchema(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.schemaInfo.outputObjectInspector));
            ResourceSchema tupleSchema = new ResourceSchema();
            tupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{rfs});
            ResourceSchema.ResourceFieldSchema bagFieldSchema = new ResourceSchema.ResourceFieldSchema();
            bagFieldSchema.setType((byte)120);
            bagFieldSchema.setSchema(tupleSchema);
            ResourceSchema bagSchema = new ResourceSchema();
            bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagFieldSchema});
            return Schema.getPigSchema(bagSchema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needEndOfAllInputProcessing() {
        return true;
    }

    @Override
    public void setEndOfAllInput(boolean endOfAllInput) {
        this.endOfAllInput = endOfAllInput;
    }

    static /* synthetic */ BagFactory access$100() {
        return bf;
    }

    class HiveUDTFCollector
    implements Collector {
        DataBag bag = HiveUDTF.access$100().newDefaultBag();

        HiveUDTFCollector() {
        }

        public void init() {
            this.bag.clear();
        }

        public void collect(Object input) throws HiveException {
            try {
                Tuple outputTuple = (Tuple)HiveUtils.convertHiveToPig(input, HiveUDTF.this.schemaInfo.outputObjectInspector, null);
                if (outputTuple.size() == 1 && outputTuple.get(0) instanceof Tuple) {
                    this.bag.add((Tuple)outputTuple.get(0));
                } else {
                    this.bag.add(outputTuple);
                }
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
        }

        public DataBag getBag() {
            return this.bag;
        }
    }

    static class SchemaInfo {
        StructObjectInspector inputObjectInspector;
        ObjectInspector outputObjectInspector;

        SchemaInfo() {
        }

        private void init(Schema inputSchema, GenericUDTF udtf, HiveUDFBase.ConstantObjectInspectInfo constantsInfo) throws IOException {
            ResourceSchema rs = new ResourceSchema(inputSchema);
            ResourceSchema.ResourceFieldSchema wrappedTupleFieldSchema = new ResourceSchema.ResourceFieldSchema();
            wrappedTupleFieldSchema.setType((byte)110);
            wrappedTupleFieldSchema.setSchema(rs);
            TypeInfo ti = HiveUtils.getTypeInfo(wrappedTupleFieldSchema);
            this.inputObjectInspector = (StructObjectInspector)HiveUtils.createObjectInspector(ti);
            if (constantsInfo != null) {
                constantsInfo.injectConstantObjectInspector(this.inputObjectInspector);
            }
            try {
                this.outputObjectInspector = udtf.initialize(this.inputObjectInspector);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

