/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.visitor.ProjectStarExpanderUtil;

class ProjExpanderForNonForeach
extends LogicalExpressionVisitor {
    protected ProjExpanderForNonForeach(OperatorPlan p) throws FrontendException {
        super(p, new ReverseDependencyOrderWalker(p));
    }

    @Override
    public void visit(UserFuncExpression func) throws FrontendException {
        if (this.plan.getSuccessors(func) == null) {
            return;
        }
        ArrayList<Operator> inputs = new ArrayList<Operator>(this.plan.getSuccessors(func));
        ArrayList<Operator> expandedProjectStars = new ArrayList<Operator>();
        ArrayList<Operator> newExpandedProjects = new ArrayList<Operator>();
        ArrayList<Operator> newInputs = new ArrayList<Operator>();
        for (Operator inp : inputs) {
            if (inp instanceof ProjectExpression && ((ProjectExpression)inp).isRangeOrStarProject()) {
                List<Operator> expandedOps = this.expandProjectStar((ProjectExpression)inp);
                if (expandedOps != null) {
                    expandedProjectStars.add(inp);
                    newInputs.addAll(expandedOps);
                    newExpandedProjects.addAll(expandedOps);
                    continue;
                }
                newInputs.add(inp);
                continue;
            }
            newInputs.add(inp);
        }
        if (expandedProjectStars.size() > 0) {
            for (Operator inp : inputs) {
                this.plan.disconnect(func, inp);
            }
            for (Operator op : expandedProjectStars) {
                this.plan.remove(op);
            }
            for (Operator op : newExpandedProjects) {
                this.plan.add(op);
            }
            for (Operator newInp : newInputs) {
                this.plan.connect(func, newInp);
            }
        }
    }

    private List<Operator> expandProjectStar(ProjectExpression proj) throws FrontendException {
        Pair<Integer, Integer> firstLastCols = ProjectStarExpanderUtil.getProjectStartEndCols((LogicalExpressionPlan)this.plan, proj);
        if (firstLastCols == null) {
            return null;
        }
        int firstProjCol = (Integer)firstLastCols.first;
        int lastProjCol = (Integer)firstLastCols.second;
        ArrayList<Operator> newProjects = new ArrayList<Operator>();
        LogicalRelationalOperator relOp = proj.getAttachedRelationalOp();
        for (int i = firstProjCol; i <= lastProjCol; ++i) {
            newProjects.add(new ProjectExpression(this.plan, proj.getInputNum(), i, relOp));
        }
        return newProjects;
    }
}

