/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.dom4j.DocumentException;
import org.pentaho.platform.config.ILdapConfig;

public class LdapConfigProperties
implements ILdapConfig {
    Properties properties;
    public static final String PROVIDER_URL_KEY = "contextSource.providerUrl";
    public static final String USER_DN_KEY = "contextSource.userDn";
    public static final String PROVIDER_PASSWORD_KEY = "contextSource.password";
    public static final String USER_SEARCH_BASE_KEY = "userSearch.searchBase";
    public static final String USER_SEARCH_FILTER_KEY = "userSearch.searchFilter";
    public static final String CONVERT_USER_ROLES_TO_UPPERCASE_KEY = "populator.convertToUpperCase";
    public static final String USER_ROLE_ATTRIBUTE_KEY = "populator.groupRoleAttribute";
    public static final String USER_ROLE_SEARCH_BASE_KEY = "populator.groupSearchBase";
    public static final String USER_ROLE_SEARCH_FILTER_KEY = "populator.groupSearchFilter";
    public static final String USER_ROLE_PREFIX_KEY = "populator.rolePrefix";
    public static final String SEARCH_SUBTREE_FOR_USER_ROLES_KEY = "populator.searchSubtree";
    public static final String ALL_ROLES_ATTRIBUTE_KEY = "allAuthoritiesSearch.roleAttribute";
    public static final String ALL_ROLES_SEARCH_BASE_KEY = "allAuthoritiesSearch.searchBase";
    public static final String ALL_ROLES_SEARCH_FILTER_KEY = "allAuthoritiesSearch.searchFilter";

    public LdapConfigProperties(File propertiesFile) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propertiesFile);
        props.load(in);
        ((InputStream)in).close();
        this.properties = props;
    }

    public LdapConfigProperties(Properties properties) throws DocumentException {
        this.properties = properties;
    }

    public LdapConfigProperties() {
        this.properties = new Properties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    @Override
    public String getAllRolesAttribute() {
        return this.getProperty(ALL_ROLES_ATTRIBUTE_KEY);
    }

    @Override
    public String getAllRolesSearchBase() {
        return this.getProperty(ALL_ROLES_SEARCH_BASE_KEY);
    }

    @Override
    public String getAllRolesSearchFilter() {
        return this.getProperty(ALL_ROLES_SEARCH_FILTER_KEY);
    }

    @Override
    public boolean getConvertUserRolesToUpperCase() {
        return Boolean.parseBoolean(this.getProperty(CONVERT_USER_ROLES_TO_UPPERCASE_KEY));
    }

    @Override
    public String getProviderPassword() {
        return this.getProperty(PROVIDER_PASSWORD_KEY);
    }

    @Override
    public String getProviderUrl() {
        return this.getProperty(PROVIDER_URL_KEY);
    }

    @Override
    public boolean getSearchSubtreeForUserRoles() {
        return Boolean.parseBoolean(this.getProperty(SEARCH_SUBTREE_FOR_USER_ROLES_KEY));
    }

    @Override
    public String getUserDn() {
        return this.getProperty(USER_DN_KEY);
    }

    @Override
    public String getUserRolesAttribute() {
        return this.getProperty(USER_ROLE_ATTRIBUTE_KEY);
    }

    @Override
    public String getUserRolesPrefix() {
        return this.getProperty(USER_ROLE_PREFIX_KEY);
    }

    @Override
    public String getUserRolesSearchBase() {
        return this.getProperty(USER_ROLE_SEARCH_BASE_KEY);
    }

    @Override
    public String getUserRolesSearchFilter() {
        return this.getProperty(USER_ROLE_SEARCH_FILTER_KEY);
    }

    @Override
    public String getUserSearchBase() {
        return this.getProperty(USER_SEARCH_BASE_KEY);
    }

    @Override
    public String getUserSearchFilter() {
        return this.getProperty(USER_SEARCH_FILTER_KEY);
    }

    @Override
    public void setAllRolesAttribute(String attr) {
        this.setProperty(ALL_ROLES_ATTRIBUTE_KEY, attr);
    }

    @Override
    public void setAllRolesSearchBase(String base) {
        this.setProperty(ALL_ROLES_SEARCH_BASE_KEY, base);
    }

    @Override
    public void setAllRolesSearchFilter(String filter) {
        this.setProperty(ALL_ROLES_SEARCH_FILTER_KEY, filter);
    }

    @Override
    public void setConvertUserRolesToUpperCase(boolean convert) {
        this.setProperty(CONVERT_USER_ROLES_TO_UPPERCASE_KEY, Boolean.toString(convert));
    }

    @Override
    public void setProviderPassword(String password) {
        this.setProperty(PROVIDER_PASSWORD_KEY, password);
    }

    @Override
    public void setProviderUrl(String url) {
        this.setProperty(PROVIDER_URL_KEY, url);
    }

    @Override
    public void setSearchSubtreeForUserRoles(boolean searchSubtree) {
        this.setProperty(SEARCH_SUBTREE_FOR_USER_ROLES_KEY, Boolean.toString(searchSubtree));
    }

    @Override
    public void setUserDn(String userDn) {
        this.setProperty(USER_DN_KEY, userDn);
    }

    @Override
    public void setUserRolesAttribute(String attr) {
        this.setProperty(USER_ROLE_ATTRIBUTE_KEY, attr);
    }

    @Override
    public void setUserRolesPrefix(String prefix) {
        this.setProperty(USER_ROLE_PREFIX_KEY, prefix);
    }

    @Override
    public void setUserRolesSearchBase(String base) {
        this.setProperty(USER_ROLE_SEARCH_BASE_KEY, base);
    }

    @Override
    public void setUserRolesSearchFilter(String filter) {
        this.setProperty(USER_ROLE_SEARCH_FILTER_KEY, filter);
    }

    @Override
    public void setUserSearchBase(String base) {
        this.setProperty(USER_SEARCH_BASE_KEY, base);
    }

    @Override
    public void setUserSearchFilter(String filter) {
        this.setProperty(USER_SEARCH_FILTER_KEY, filter);
    }
}

