/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.examples;

import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.actions.HelloWorldAction;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class HelloWorldComponent
extends ComponentBase {
    private static final long serialVersionUID = 9050456842938084174L;

    public Log getLogger() {
        return LogFactory.getLog(HelloWorldComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        boolean result = true;
        if (!(this.getActionDefinition() instanceof HelloWorldAction)) {
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
            result = false;
        }
        return result;
    }

    public void done() {
    }

    protected boolean executeAction() {
        HelloWorldAction helloWorldAction = (HelloWorldAction)this.getActionDefinition();
        boolean result = true;
        String msg = Messages.getInstance().getString("HelloWorld.USER_HELLO_WORLD_TEXT", new Object[]{helloWorldAction.getQuote().getStringValue("")});
        OutputStream outputStream = this.getDefaultOutputStream("text/html");
        if (outputStream != null) {
            try {
                outputStream.write(msg.getBytes(LocaleHelper.getSystemEncoding()));
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("HelloWorld.ERROR_0001_COULDNOTWRITE"), e);
                result = false;
            }
        }
        this.info(msg);
        return result;
    }

    public boolean init() {
        return true;
    }
}

