/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.components;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;
import org.pentaho.jfreereport.wizard.utility.CastorUtility;
import org.pentaho.jfreereport.wizard.utility.report.ReportGenerationUtility;
import org.pentaho.jfreereport.wizard.utility.report.ReportParameterUtility;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.action.jfreereport.AbstractJFreeReportComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.util.messages.LocaleHelper;

@Deprecated
public class JFreeReportGenerateDefinitionComponent
extends AbstractJFreeReportComponent {
    private static final long serialVersionUID = -6364796568478754207L;

    protected boolean validateAction() {
        return this.isDefinedResource("report-spec");
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    private ZipEntry findReportSpec(ZipInputStream zStrm) throws IOException {
        ZipEntry reportSpecEntry = null;
        reportSpecEntry = zStrm.getNextEntry();
        while (null != reportSpecEntry && !reportSpecEntry.getName().endsWith(".xreportspec")) {
            boolean bl = true;
            reportSpecEntry = zStrm.getNextEntry();
        }
        return reportSpecEntry;
    }

    private ReportSpec loadFromZip(IActionSequenceResource resource) {
        try {
            InputStream reportSpecInputStream = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
            ZipInputStream zis = new ZipInputStream(reportSpecInputStream);
            ZipEntry reportSpecEntry = this.findReportSpec(zis);
            if (reportSpecEntry == null) {
                return null;
            }
            return (ReportSpec)CastorUtility.getInstance().readCastorObject((InputStream)zis, ReportSpec.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ReportSpec getReportSpec() throws FileNotFoundException {
        IActionSequenceResource resource;
        ReportSpec reportSpec = null;
        if (this.isDefinedResource("report-spec") && (reportSpec = this.loadFromZip(resource = this.getResource("report-spec"))) == null) {
            InputStream reportSpecInputStream = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
            reportSpec = (ReportSpec)CastorUtility.getInstance().readCastorObject(reportSpecInputStream, ReportSpec.class);
        }
        return reportSpec;
    }

    public IPentahoResultSet getResultSet(ReportSpec reportSpec) throws Exception {
        String jndiName = reportSpec.getReportSpecChoice().getJndiSource();
        IPentahoConnection connection = null;
        if (reportSpec.getIsMDX()) {
            String connectStr = "";
            IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
            String dsName = datasourceService.getDSBoundName(jndiName);
            if (dsName == null) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                return null;
            }
            connectStr = "dataSource=" + dsName + "; Catalog=mondrian";
            Properties props = new Properties();
            props.setProperty("connection", connectStr);
            props.setProperty("provider", reportSpec.getMondrianCubeDefinitionPath());
            connection = PentahoConnectionFactory.getConnection((String)"MDX", (Properties)props, (IPentahoSession)this.getSession(), (ILogger)this);
        } else {
            connection = PentahoConnectionFactory.getConnection((String)"SQL", (String)jndiName, (IPentahoSession)this.getSession(), (ILogger)this);
        }
        String query = ReportParameterUtility.setupParametersForActionSequence((String)reportSpec.getQuery());
        query = this.setupQueryParameters(query);
        IPentahoResultSet res = connection.executeQuery(query);
        return res;
    }

    protected boolean executeAction() {
        boolean result = true;
        try {
            ReportSpec reportSpec = this.getReportSpec();
            if (reportSpec != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ReportGenerationUtility.createJFreeReportXML((ReportSpec)reportSpec, (OutputStream)outputStream, (int)0, (int)0, (boolean)false, (String)"", (int)0, (int)0);
                String reportDefinition = new String(outputStream.toByteArray());
                this.addTempParameterObject("report-definition", reportDefinition);
                if (!this.isDefinedInput("_PERFORM.QUERY") || "true".equals(this.getInputParameter("_PERFORM.QUERY"))) {
                    try {
                        this.addTempParameterObject("data", this.getResultSet(reportSpec));
                    }
                    catch (Exception e) {
                        result = false;
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.error(ex.getLocalizedMessage());
            result = false;
        }
        return result;
    }

    public boolean init() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(JFreeReportGenerateDefinitionComponent.class);
    }

    public String setupQueryParameters(String query) {
        Set inputNames = this.getInputNames();
        for (String inputName : inputNames) {
            IActionParameter inputParameter = this.getInputParameter(inputName);
            Object value = inputParameter.getValue();
            if (!(value instanceof String)) continue;
            String paramValue = (String)value;
            String param = "\\{" + inputName + "\\}";
            query = query.replaceAll(param, paramValue);
        }
        return query;
    }
}

