/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class PentahoResourceLoader
implements ResourceLoader {
    public static final String SOLUTION_SCHEMA_NAME = "solution";
    public static final String HTTP_URL_PREFIX = "http://";
    public static final String SCHEMA_SEPARATOR = ":/";
    public static final String PATH_SEPARATOR = "/";
    public static final String WIN_PATH_SEPARATOR = "\\";
    private ResourceManager manager;

    public void setResourceManager(ResourceManager manager) {
        this.manager = manager;
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public String getSchema() {
        return SOLUTION_SCHEMA_NAME;
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        return new PentahoResourceData(key);
    }

    public boolean isSupportedKey(ResourceKey key) {
        return key.getSchema().equals(this.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String valueString;
        if (value instanceof String && (valueString = (String)value).startsWith(this.getSchema() + SCHEMA_SEPARATOR)) {
            valueString = valueString.replace('\\', '/');
            String path = valueString.substring(this.getSchema().length() + SCHEMA_SEPARATOR.length());
            return new ResourceKey((Object)this.getSchema(), (Object)path, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map data) throws ResourceKeyCreationException {
        HashMap map;
        String resource;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        if (path.startsWith("solution://")) {
            resource = path;
        } else if (path.startsWith(PATH_SEPARATOR)) {
            resource = "solution:/" + path;
        } else {
            resource = LoaderUtils.mergePaths((String)((String)parent.getIdentifier()), (String)path);
            if (!resource.startsWith(HTTP_URL_PREFIX) && !resource.startsWith(PATH_SEPARATOR)) {
                resource = PATH_SEPARATOR + resource;
            }
        }
        if (data != null) {
            map = new HashMap();
            map.putAll(parent.getFactoryParameters());
            map.putAll(data);
        } else {
            map = parent.getFactoryParameters();
        }
        return new ResourceKey(parent.getSchema(), (Object)resource, map);
    }

    public URL toURL(ResourceKey key) {
        return null;
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        return null;
    }

    public boolean isSupportedDeserializer(String data) {
        return false;
    }

    public String serialize(ResourceKey resourceKey, ResourceKey key) throws ResourceException {
        return null;
    }
}

