/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IMultiDimensionalMetaData;
import org.pentaho.commons.connection.IMultiDimensionalResultSet;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;

public class PentahoTableModel
extends AbstractTableModel
implements CloseableTableModel {
    private static final long serialVersionUID = 696878055074045444L;
    private IPentahoResultSet resultSet;
    private transient Object[][] rowHeaders;

    public PentahoTableModel(IPentahoResultSet rs) {
        this.resultSet = rs;
    }

    public Log getLogger() {
        return LogFactory.getLog(this.getClass());
    }

    @Override
    public int getColumnCount() {
        if (this.resultSet == null) {
            return 0;
        }
        if (this.rowHeaders == null) {
            this.rowHeaders = this.resultSet.getMetaData().getRowHeaders();
        }
        if (this.rowHeaders != null && this.rowHeaders.length > 0) {
            return this.rowHeaders[0].length + this.resultSet.getColumnCount();
        }
        return this.resultSet.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.resultSet == null) {
            return null;
        }
        if (this.rowHeaders == null) {
            this.rowHeaders = this.resultSet.getMetaData().getRowHeaders();
        }
        if (this.rowHeaders != null) {
            if (columnIndex < this.rowHeaders[0].length) {
                return this.rowHeaders[rowIndex][columnIndex];
            }
            columnIndex -= this.rowHeaders[0].length;
        }
        Object val = null;
        try {
            val = this.resultSet.getValueAt(rowIndex, columnIndex);
        }
        catch (IndexOutOfBoundsException e1) {
            this.getLogger().info((Object)Messages.getInstance().getErrorString("PentahoTableModel.ERROR_0001_GET_VALUE_AT"));
        }
        catch (Throwable t) {
            IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
            this.getLogger().error((Object)("Error Start: Pentaho " + versionHelper.getVersionInformation(this.getClass())));
            this.getLogger().error((Object)Messages.getInstance().getErrorString("PentahoTableModel.ERROR_0001_GET_VALUE_AT"), t);
            this.getLogger().error((Object)"Error end:");
        }
        return val;
    }

    @Override
    public int getRowCount() {
        if (this.resultSet != null) {
            return this.resultSet.getRowCount();
        }
        return 0;
    }

    @Override
    public String getColumnName(int columnNumber) {
        if (this.resultSet == null) {
            return null;
        }
        Object[][] columnHeaders = this.resultSet.getMetaData().getColumnHeaders();
        if (this.rowHeaders == null) {
            this.rowHeaders = this.resultSet.getMetaData().getRowHeaders();
        }
        if (this.rowHeaders != null && this.rowHeaders.length > 0) {
            if (columnNumber < this.rowHeaders[0].length) {
                if (this.resultSet instanceof IMultiDimensionalResultSet) {
                    String[] columnNames = ((IMultiDimensionalMetaData)this.resultSet.getMetaData()).getRowHeaderNames();
                    return columnNumber >= 0 && columnNumber < columnNames.length ? columnNames[columnNumber] : "";
                }
            } else {
                columnNumber -= this.rowHeaders[0].length;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (columnHeaders != null && columnHeaders.length > 0) {
            for (int i = 0; i < columnHeaders.length; ++i) {
                if (i > 0) {
                    buf.append("/");
                }
                buf.append(columnHeaders[i][columnNumber].toString());
            }
        }
        return buf.toString();
    }

    public void close() {
        if (this.resultSet != null) {
            this.resultSet.closeConnection();
            this.resultSet.close();
        }
        this.resultSet = null;
        this.fireTableStructureChanged();
    }
}

