/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;

public class MondrianSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<MondrianCube> cubes;
    private String[] roleNames;

    public MondrianSchema(String name, List<MondrianCube> cubes) {
        this(name, cubes, null);
    }

    public MondrianSchema(String name, List<MondrianCube> cubes, String[] roles) {
        this.name = name;
        this.cubes = cubes;
        if (roles != null) {
            if (roles.length > 0) {
                this.roleNames = new String[roles.length];
                System.arraycopy(roles, 0, this.roleNames, 0, roles.length);
                Arrays.sort(this.roleNames);
            } else {
                this.roleNames = new String[0];
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List<MondrianCube> getCubes() {
        return this.cubes;
    }

    public String[] getRoleNames() {
        return this.roleNames;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("cubes", this.cubes).toString();
    }
}

