/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.olap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.xmla.XmlaHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.Schema;

public class PlatformXmlaExtra
implements XmlaHandler.XmlaExtra {
    private static final String MONDRIAN_XMLA_EXTRA_NAME = "mondrian.xmla.XmlaHandler$XmlaExtra";
    private static final String MONDRIAN_ROLAP_CONNECTION_NAME = "mondrian.rolap.RolapConnection";
    private static final Log logger = LogFactory.getLog(PlatformXmlaExtra.class);
    private Class<?> clazz;
    private Object xmlaExtra;

    public static XmlaHandler.XmlaExtra unwrapXmlaExtra(OlapConnection olap4jConn) throws SQLException {
        try {
            PlatformXmlaExtra platformXmlaExtra;
            if (PlatformXmlaExtra.inCurrentClassLoader(olap4jConn)) {
                return (XmlaHandler.XmlaExtra)olap4jConn.unwrap(XmlaHandler.XmlaExtra.class);
            }
            if (PlatformXmlaExtra.isMondrianConnection(olap4jConn) && (platformXmlaExtra = new PlatformXmlaExtra(olap4jConn)).isValid()) {
                return platformXmlaExtra;
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Problem unwrapping XmlaExtra", (Throwable)e);
        }
        return null;
    }

    private boolean isValid() {
        return this.clazz != null && this.xmlaExtra != null;
    }

    private static boolean isMondrianConnection(OlapConnection olap4jConn) throws SQLException, ClassNotFoundException {
        return olap4jConn.isWrapperFor(olap4jConn.getClass().getClassLoader().loadClass(MONDRIAN_ROLAP_CONNECTION_NAME));
    }

    private static boolean inCurrentClassLoader(OlapConnection olap4jConn) throws ClassNotFoundException {
        return olap4jConn.getClass().getClassLoader().loadClass(MONDRIAN_XMLA_EXTRA_NAME).equals(XmlaHandler.XmlaExtra.class);
    }

    private PlatformXmlaExtra(OlapConnection olap4jConn) {
        try {
            this.clazz = olap4jConn.getClass().getClassLoader().loadClass(MONDRIAN_XMLA_EXTRA_NAME);
            this.xmlaExtra = olap4jConn.unwrap(this.clazz);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to retrieve XmlaExtra", (Throwable)e);
        }
    }

    public Object invoke(String methodName, Class<?> paramType, Object param, Object defaultValue) {
        try {
            return this.clazz.getMethod(methodName, paramType).invoke(this.xmlaExtra, param);
        }
        catch (Exception e) {
            logger.warn((Object)("Using default value for " + methodName), (Throwable)e);
            return defaultValue;
        }
    }

    public ResultSet executeDrillthrough(OlapStatement olapStatement, String s, boolean b, String s2, int[] ints) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setPreferList(OlapConnection olapConnection) {
        throw new UnsupportedOperationException();
    }

    public Date getSchemaLoadDate(Schema schema) {
        throw new UnsupportedOperationException();
    }

    public int getLevelCardinality(Level level) throws OlapException {
        throw new UnsupportedOperationException();
    }

    public void getSchemaFunctionList(List<XmlaHandler.XmlaExtra.FunctionDefinition> functionDefinitions, Schema schema, Util.Functor1<Boolean, String> booleanStringFunctor1) {
        throw new UnsupportedOperationException();
    }

    public int getHierarchyCardinality(Hierarchy hierarchy) throws OlapException {
        throw new UnsupportedOperationException();
    }

    public int getHierarchyStructure(Hierarchy hierarchy) {
        throw new UnsupportedOperationException();
    }

    public boolean isHierarchyParentChild(Hierarchy hierarchy) {
        return (Boolean)this.invoke("isHierarchyParentChild", Hierarchy.class, hierarchy, false);
    }

    public int getMeasureAggregator(Member member) {
        throw new UnsupportedOperationException();
    }

    public void checkMemberOrdinal(Member member) throws OlapException {
        throw new UnsupportedOperationException();
    }

    public boolean shouldReturnCellProperty(CellSet cellSet, Property property, boolean b) {
        throw new UnsupportedOperationException();
    }

    public List<String> getSchemaRoleNames(Schema schema) {
        throw new UnsupportedOperationException();
    }

    public String getSchemaId(Schema schema) {
        return (String)this.invoke("getSchemaId", Schema.class, schema, "");
    }

    public String getCubeType(Cube cube) {
        throw new UnsupportedOperationException();
    }

    public boolean isLevelUnique(Level level) {
        throw new UnsupportedOperationException();
    }

    public List<Property> getLevelProperties(Level level) {
        return (List)this.invoke("getLevelProperties", Level.class, level, Collections.emptyList());
    }

    public boolean isPropertyInternal(Property property) {
        throw new UnsupportedOperationException();
    }

    public List<Map<String, Object>> getDataSources(OlapConnection olapConnection) throws OlapException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getAnnotationMap(MetadataElement metadataElement) throws SQLException {
        return (Map)this.invoke("getAnnotationMap", MetadataElement.class, metadataElement, Collections.emptyMap());
    }

    public boolean canDrillThrough(Cell cell) {
        return (Boolean)this.invoke("canDrillThrough", Cell.class, cell, false);
    }

    public int getDrillThroughCount(Cell cell) {
        return (Integer)this.invoke("getDrillThroughCount", Cell.class, cell, 0);
    }

    public void flushSchemaCache(OlapConnection olapConnection) throws OlapException {
        this.invoke("flushSchemaCache", OlapConnection.class, olapConnection, null);
    }

    public Object getMemberKey(Member member) throws OlapException {
        return this.invoke("getMemberKey", Member.class, member, null);
    }

    public Object getOrderKey(Member member) throws OlapException {
        return this.invoke("getOrderKey", Member.class, member, null);
    }
}

